"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DropViewNode = void 0;
const object_utils_js_1 = require("../util/object-utils.js");
const schemable_identifier_node_js_1 = require("./schemable-identifier-node.js");
/**
 * @internal
 */
exports.DropViewNode = (0, object_utils_js_1.freeze)({
    is(node) {
        return node.kind === 'DropViewNode';
    },
    create(name) {
        return (0, object_utils_js_1.freeze)({
            kind: 'DropViewNode',
            name: schemable_identifier_node_js_1.SchemableIdentifierNode.create(name),
        });
    },
    cloneWith(dropView, params) {
        return (0, object_utils_js_1.freeze)({
            ...dropView,
            ...params,
        });
    },
});
