"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PromptConfirmMoveQuestions = exports.PromptMediaLocationQuestions = exports.ChangeMediaLocationCommand = void 0;
const nest_commander_1 = require("nest-commander");
const cli_service_1 = require("../services/cli.service");
let ChangeMediaLocationCommand = class ChangeMediaLocationCommand extends nest_commander_1.CommandRunner {
    service;
    inquirer;
    constructor(service, inquirer) {
        super();
        this.service = service;
        this.inquirer = inquirer;
    }
    async showSamplePaths(hint) {
        hint = hint ? ` (${hint})` : '';
        const paths = await this.service.getSampleFilePaths();
        if (paths.length > 0) {
            let message = `  Examples from the database${hint}:\n`;
            for (const path of paths) {
                message += `  - ${path}\n`;
            }
            console.log(`\n${message}`);
        }
    }
    async run() {
        try {
            await this.showSamplePaths();
            const { oldValue, newValue } = await this.inquirer.ask('prompt-media-location', {});
            const success = await this.service.migrateFilePaths({
                oldValue,
                newValue,
                confirm: async ({ sourceFolder, targetFolder }) => {
                    console.log(`
  Previous value: ${oldValue}
  Current value:  ${newValue}

  Changing  from "${sourceFolder}/*" to "${targetFolder}/*"
`);
                    const { value: confirmed } = await this.inquirer.ask('prompt-confirm-move', {});
                    return confirmed;
                },
            });
            const successMessage = `Matching database file paths were updated successfully! 🎉

  You may now set IMMICH_MEDIA_LOCATION=${newValue} and restart!

  (please remember to update applicable volume mounts e.g
    services:
      immich-server:
        ...
        volumes:
          - \${UPLOAD_LOCATION}:/data
        ...
  )`;
            console.log(`\n  ${success ? successMessage : 'No rows were updated'}\n`);
            await this.showSamplePaths('after');
        }
        catch (error) {
            console.error(error);
            console.error('Unable to update database file paths.');
        }
    }
};
exports.ChangeMediaLocationCommand = ChangeMediaLocationCommand;
exports.ChangeMediaLocationCommand = ChangeMediaLocationCommand = __decorate([
    (0, nest_commander_1.Command)({
        name: 'change-media-location',
        description: 'Change database file paths to align with a new media location',
    }),
    __metadata("design:paramtypes", [cli_service_1.CliService,
        nest_commander_1.InquirerService])
], ChangeMediaLocationCommand);
const currentValue = process.env.IMMICH_MEDIA_LOCATION || '';
const makePrompt = (which) => {
    return `Enter the ${which} value of IMMICH_MEDIA_LOCATION:${currentValue ? ` [${currentValue}]` : ''}`;
};
let PromptMediaLocationQuestions = class PromptMediaLocationQuestions {
    oldValue(value) {
        return value || currentValue;
    }
    newValue(value) {
        return value || currentValue;
    }
};
exports.PromptMediaLocationQuestions = PromptMediaLocationQuestions;
__decorate([
    (0, nest_commander_1.Question)({ message: makePrompt('previous'), name: 'oldValue' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PromptMediaLocationQuestions.prototype, "oldValue", null);
__decorate([
    (0, nest_commander_1.Question)({ message: makePrompt('new'), name: 'newValue' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PromptMediaLocationQuestions.prototype, "newValue", null);
exports.PromptMediaLocationQuestions = PromptMediaLocationQuestions = __decorate([
    (0, nest_commander_1.QuestionSet)({ name: 'prompt-media-location' })
], PromptMediaLocationQuestions);
let PromptConfirmMoveQuestions = class PromptConfirmMoveQuestions {
    value(value) {
        return ['yes', 'y'].includes((value || 'y').toLowerCase());
    }
};
exports.PromptConfirmMoveQuestions = PromptConfirmMoveQuestions;
__decorate([
    (0, nest_commander_1.Question)({
        message: 'Do you want to proceed? [Y/n]',
        name: 'value',
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Boolean)
], PromptConfirmMoveQuestions.prototype, "value", null);
exports.PromptConfirmMoveQuestions = PromptConfirmMoveQuestions = __decorate([
    (0, nest_commander_1.QuestionSet)({ name: 'prompt-confirm-move' })
], PromptConfirmMoveQuestions);
//# sourceMappingURL=media-location.command.js.map