import { Request, Response } from 'express';
import { AuthDto, AuthStatusResponseDto, ChangePasswordDto, LoginCredentialDto, LoginResponseDto, LogoutResponseDto, PinCodeChangeDto, PinCodeResetDto, PinCodeSetupDto, SessionUnlockDto, SignUpDto, ValidateAccessTokenResponseDto } from 'src/dtos/auth.dto';
import { UserAdminResponseDto } from 'src/dtos/user.dto';
import { AuthService, LoginDetails } from 'src/services/auth.service';
export declare class AuthController {
    private service;
    constructor(service: AuthService);
    login(res: Response, loginCredential: LoginCredentialDto, loginDetails: LoginDetails): Promise<LoginResponseDto>;
    signUpAdmin(dto: SignUpDto): Promise<UserAdminResponseDto>;
    validateAccessToken(): ValidateAccessTokenResponseDto;
    changePassword(auth: AuthDto, dto: ChangePasswordDto): Promise<UserAdminResponseDto>;
    logout(request: Request, res: Response, auth: AuthDto): Promise<LogoutResponseDto>;
    getAuthStatus(auth: AuthDto): Promise<AuthStatusResponseDto>;
    setupPinCode(auth: AuthDto, dto: PinCodeSetupDto): Promise<void>;
    changePinCode(auth: AuthDto, dto: PinCodeChangeDto): Promise<void>;
    resetPinCode(auth: AuthDto, dto: PinCodeResetDto): Promise<void>;
    unlockAuthSession(auth: AuthDto, dto: SessionUnlockDto): Promise<void>;
    lockAuthSession(auth: AuthDto): Promise<void>;
}
