"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StackController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const decorators_1 = require("../decorators");
const asset_ids_response_dto_1 = require("../dtos/asset-ids.response.dto");
const auth_dto_1 = require("../dtos/auth.dto");
const stack_dto_1 = require("../dtos/stack.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const stack_service_1 = require("../services/stack.service");
const validation_1 = require("../validation");
let StackController = class StackController {
    service;
    constructor(service) {
        this.service = service;
    }
    searchStacks(auth, query) {
        return this.service.search(auth, query);
    }
    createStack(auth, dto) {
        return this.service.create(auth, dto);
    }
    deleteStacks(auth, dto) {
        return this.service.deleteAll(auth, dto);
    }
    getStack(auth, { id }) {
        return this.service.get(auth, id);
    }
    updateStack(auth, { id }, dto) {
        return this.service.update(auth, id, dto);
    }
    deleteStack(auth, { id }) {
        return this.service.delete(auth, id);
    }
    removeAssetFromStack(auth, dto) {
        return this.service.removeAsset(auth, dto);
    }
};
exports.StackController = StackController;
__decorate([
    (0, common_1.Get)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.StackRead }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve stacks',
        description: 'Retrieve a list of stacks.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/stack.dto").StackResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, stack_dto_1.StackSearchDto]),
    __metadata("design:returntype", Promise)
], StackController.prototype, "searchStacks", null);
__decorate([
    (0, common_1.Post)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.StackCreate }),
    (0, decorators_1.Endpoint)({
        summary: 'Create a stack',
        description: 'Create a new stack by providing a name and a list of asset IDs to include in the stack. If any of the provided asset IDs are primary assets of an existing stack, the existing stack will be merged into the newly created stack.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 201, type: require("../dtos/stack.dto").StackResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, stack_dto_1.StackCreateDto]),
    __metadata("design:returntype", Promise)
], StackController.prototype, "createStack", null);
__decorate([
    (0, common_1.Delete)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.StackDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    (0, decorators_1.Endpoint)({
        summary: 'Delete stacks',
        description: 'Delete multiple stacks by providing a list of stack IDs.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, asset_ids_response_dto_1.BulkIdsDto]),
    __metadata("design:returntype", Promise)
], StackController.prototype, "deleteStacks", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.StackRead }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve a stack',
        description: 'Retrieve a specific stack by its ID.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/stack.dto").StackResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], StackController.prototype, "getStack", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.StackUpdate }),
    (0, decorators_1.Endpoint)({
        summary: 'Update a stack',
        description: 'Update an existing stack by its ID.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/stack.dto").StackResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        stack_dto_1.StackUpdateDto]),
    __metadata("design:returntype", Promise)
], StackController.prototype, "updateStack", null);
__decorate([
    (0, common_1.Delete)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.StackDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    (0, decorators_1.Endpoint)({
        summary: 'Delete a stack',
        description: 'Delete a specific stack by its ID.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], StackController.prototype, "deleteStack", null);
__decorate([
    (0, common_1.Delete)(':id/assets/:assetId'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.StackUpdate }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    (0, decorators_1.Endpoint)({
        summary: 'Remove an asset from a stack',
        description: 'Remove a specific asset from a stack by providing the stack ID and asset ID.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDAssetIDParamDto]),
    __metadata("design:returntype", Promise)
], StackController.prototype, "removeAssetFromStack", null);
exports.StackController = StackController = __decorate([
    (0, swagger_1.ApiTags)(enum_1.ApiTag.Stacks),
    (0, common_1.Controller)('stacks'),
    __metadata("design:paramtypes", [stack_service_1.StackService])
], StackController);
//# sourceMappingURL=stack.controller.js.map