"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SystemMetadataController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const decorators_1 = require("../decorators");
const system_metadata_dto_1 = require("../dtos/system-metadata.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const system_metadata_service_1 = require("../services/system-metadata.service");
let SystemMetadataController = class SystemMetadataController {
    service;
    constructor(service) {
        this.service = service;
    }
    getAdminOnboarding() {
        return this.service.getAdminOnboarding();
    }
    updateAdminOnboarding(dto) {
        return this.service.updateAdminOnboarding(dto);
    }
    getReverseGeocodingState() {
        return this.service.getReverseGeocodingState();
    }
    getVersionCheckState() {
        return this.service.getVersionCheckState();
    }
};
exports.SystemMetadataController = SystemMetadataController;
__decorate([
    (0, common_1.Get)('admin-onboarding'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.SystemMetadataRead, admin: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve admin onboarding',
        description: 'Retrieve the current admin onboarding status.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/system-metadata.dto").AdminOnboardingUpdateDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], SystemMetadataController.prototype, "getAdminOnboarding", null);
__decorate([
    (0, common_1.Post)('admin-onboarding'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.SystemMetadataUpdate, admin: true }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    (0, decorators_1.Endpoint)({
        summary: 'Update admin onboarding',
        description: 'Update the admin onboarding status.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [system_metadata_dto_1.AdminOnboardingUpdateDto]),
    __metadata("design:returntype", Promise)
], SystemMetadataController.prototype, "updateAdminOnboarding", null);
__decorate([
    (0, common_1.Get)('reverse-geocoding-state'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.SystemMetadataRead, admin: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve reverse geocoding state',
        description: 'Retrieve the current state of the reverse geocoding import.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/system-metadata.dto").ReverseGeocodingStateResponseDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], SystemMetadataController.prototype, "getReverseGeocodingState", null);
__decorate([
    (0, common_1.Get)('version-check-state'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.SystemMetadataRead, admin: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve version check state',
        description: 'Retrieve the current state of the version check process.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/system-metadata.dto").VersionCheckStateResponseDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], SystemMetadataController.prototype, "getVersionCheckState", null);
exports.SystemMetadataController = SystemMetadataController = __decorate([
    (0, swagger_1.ApiTags)(enum_1.ApiTag.SystemMetadata),
    (0, common_1.Controller)('system-metadata'),
    __metadata("design:paramtypes", [system_metadata_service_1.SystemMetadataService])
], SystemMetadataController);
//# sourceMappingURL=system-metadata.controller.js.map