"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TagController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const decorators_1 = require("../decorators");
const asset_ids_response_dto_1 = require("../dtos/asset-ids.response.dto");
const auth_dto_1 = require("../dtos/auth.dto");
const tag_dto_1 = require("../dtos/tag.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const tag_service_1 = require("../services/tag.service");
const validation_1 = require("../validation");
let TagController = class TagController {
    service;
    constructor(service) {
        this.service = service;
    }
    createTag(auth, dto) {
        return this.service.create(auth, dto);
    }
    getAllTags(auth) {
        return this.service.getAll(auth);
    }
    upsertTags(auth, dto) {
        return this.service.upsert(auth, dto);
    }
    bulkTagAssets(auth, dto) {
        return this.service.bulkTagAssets(auth, dto);
    }
    getTagById(auth, { id }) {
        return this.service.get(auth, id);
    }
    updateTag(auth, { id }, dto) {
        return this.service.update(auth, id, dto);
    }
    deleteTag(auth, { id }) {
        return this.service.remove(auth, id);
    }
    tagAssets(auth, { id }, dto) {
        return this.service.addAssets(auth, id, dto);
    }
    untagAssets(auth, dto, { id }) {
        return this.service.removeAssets(auth, id, dto);
    }
};
exports.TagController = TagController;
__decorate([
    (0, common_1.Post)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.TagCreate }),
    (0, decorators_1.Endpoint)({
        summary: 'Create a tag',
        description: 'Create a new tag by providing a name and optional color.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 201, type: require("../dtos/tag.dto").TagResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, tag_dto_1.TagCreateDto]),
    __metadata("design:returntype", Promise)
], TagController.prototype, "createTag", null);
__decorate([
    (0, common_1.Get)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.TagRead }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve tags',
        description: 'Retrieve a list of all tags.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/tag.dto").TagResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], TagController.prototype, "getAllTags", null);
__decorate([
    (0, common_1.Put)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.TagCreate }),
    (0, decorators_1.Endpoint)({
        summary: 'Upsert tags',
        description: 'Create or update multiple tags in a single request.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/tag.dto").TagResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, tag_dto_1.TagUpsertDto]),
    __metadata("design:returntype", Promise)
], TagController.prototype, "upsertTags", null);
__decorate([
    (0, common_1.Put)('assets'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.TagAsset }),
    (0, decorators_1.Endpoint)({
        summary: 'Tag assets',
        description: 'Add multiple tags to multiple assets in a single request.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/tag.dto").TagBulkAssetsResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, tag_dto_1.TagBulkAssetsDto]),
    __metadata("design:returntype", Promise)
], TagController.prototype, "bulkTagAssets", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.TagRead }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve a tag',
        description: 'Retrieve a specific tag by its ID.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/tag.dto").TagResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], TagController.prototype, "getTagById", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.TagUpdate }),
    (0, decorators_1.Endpoint)({
        summary: 'Update a tag',
        description: 'Update an existing tag identified by its ID.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/tag.dto").TagResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto, tag_dto_1.TagUpdateDto]),
    __metadata("design:returntype", Promise)
], TagController.prototype, "updateTag", null);
__decorate([
    (0, common_1.Delete)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.TagDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    (0, decorators_1.Endpoint)({
        summary: 'Delete a tag',
        description: 'Delete a specific tag by its ID.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], TagController.prototype, "deleteTag", null);
__decorate([
    (0, common_1.Put)(':id/assets'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.TagAsset }),
    (0, decorators_1.Endpoint)({
        summary: 'Tag assets',
        description: 'Add a tag to all the specified assets.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/asset-ids.response.dto").BulkIdResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        asset_ids_response_dto_1.BulkIdsDto]),
    __metadata("design:returntype", Promise)
], TagController.prototype, "tagAssets", null);
__decorate([
    (0, common_1.Delete)(':id/assets'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.TagAsset }),
    (0, decorators_1.Endpoint)({
        summary: 'Untag assets',
        description: 'Remove a tag from all the specified assets.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/asset-ids.response.dto").BulkIdResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        asset_ids_response_dto_1.BulkIdsDto,
        validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], TagController.prototype, "untagAssets", null);
exports.TagController = TagController = __decorate([
    (0, swagger_1.ApiTags)(enum_1.ApiTag.Tags),
    (0, common_1.Controller)('tags'),
    __metadata("design:paramtypes", [tag_service_1.TagService])
], TagController);
//# sourceMappingURL=tag.controller.js.map