import { AssetMetadataUpsertItemDto } from 'src/dtos/asset.dto';
import { AssetVisibility } from 'src/enum';
export declare enum AssetMediaSize {
    Original = "original",
    FULLSIZE = "fullsize",
    PREVIEW = "preview",
    THUMBNAIL = "thumbnail"
}
export declare class AssetMediaOptionsDto {
    size?: AssetMediaSize;
    edited?: boolean;
}
export declare enum UploadFieldName {
    ASSET_DATA = "assetData",
    SIDECAR_DATA = "sidecarData",
    PROFILE_DATA = "file"
}
declare class AssetMediaBase {
    deviceAssetId: string;
    deviceId: string;
    fileCreatedAt: Date;
    fileModifiedAt: Date;
    duration?: string;
    filename?: string;
    [UploadFieldName.ASSET_DATA]: any;
}
export declare class AssetMediaCreateDto extends AssetMediaBase {
    isFavorite?: boolean;
    visibility?: AssetVisibility;
    livePhotoVideoId?: string;
    metadata?: AssetMetadataUpsertItemDto[];
    [UploadFieldName.SIDECAR_DATA]?: any;
}
export declare class AssetMediaReplaceDto extends AssetMediaBase {
}
export declare class AssetBulkUploadCheckItem {
    id: string;
    checksum: string;
}
export declare class AssetBulkUploadCheckDto {
    assets: AssetBulkUploadCheckItem[];
}
export declare class CheckExistingAssetsDto {
    deviceAssetIds: string[];
    deviceId: string;
}
export {};
