"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DownloadArchiveInfo = exports.DownloadResponseDto = exports.DownloadInfoDto = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const validation_1 = require("../validation");
class DownloadInfoDto {
    assetIds;
    albumId;
    userId;
    archiveSize;
    static _OPENAPI_METADATA_FACTORY() {
        return { assetIds: { required: false, type: () => [String] }, albumId: { required: false, type: () => String }, userId: { required: false, type: () => String }, archiveSize: { required: false, type: () => Number, minimum: 1 } };
    }
}
exports.DownloadInfoDto = DownloadInfoDto;
__decorate([
    (0, validation_1.ValidateUUID)({ each: true, optional: true, description: 'Asset IDs to download' }),
    __metadata("design:type", Array)
], DownloadInfoDto.prototype, "assetIds", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true, description: 'Album ID to download' }),
    __metadata("design:type", String)
], DownloadInfoDto.prototype, "albumId", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true, description: 'User ID to download assets from' }),
    __metadata("design:type", String)
], DownloadInfoDto.prototype, "userId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ type: 'integer', description: 'Archive size limit in bytes' }),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.IsPositive)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", Number)
], DownloadInfoDto.prototype, "archiveSize", void 0);
class DownloadResponseDto {
    totalSize;
    archives;
    static _OPENAPI_METADATA_FACTORY() {
        return { totalSize: { required: true, type: () => Number }, archives: { required: true, type: () => [require("./download.dto").DownloadArchiveInfo] } };
    }
}
exports.DownloadResponseDto = DownloadResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Total size in bytes' }),
    __metadata("design:type", Number)
], DownloadResponseDto.prototype, "totalSize", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Archive information' }),
    __metadata("design:type", Array)
], DownloadResponseDto.prototype, "archives", void 0);
class DownloadArchiveInfo {
    size;
    assetIds;
    static _OPENAPI_METADATA_FACTORY() {
        return { size: { required: true, type: () => Number }, assetIds: { required: true, type: () => [String] } };
    }
}
exports.DownloadArchiveInfo = DownloadArchiveInfo;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Archive size in bytes' }),
    __metadata("design:type", Number)
], DownloadArchiveInfo.prototype, "size", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Asset IDs in this archive' }),
    __metadata("design:type", Array)
], DownloadArchiveInfo.prototype, "assetIds", void 0);
//# sourceMappingURL=download.dto.js.map