"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueueResponseDto = exports.QueueStatisticsDto = exports.QueueJobResponseDto = exports.QueueJobSearchDto = exports.QueueDeleteDto = exports.QueueUpdateDto = exports.QueueCommandDto = exports.QueueNameParamDto = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
const validation_1 = require("../validation");
class QueueNameParamDto {
    name;
    static _OPENAPI_METADATA_FACTORY() {
        return { name: { required: true, enum: require("../enum").QueueName } };
    }
}
exports.QueueNameParamDto = QueueNameParamDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.QueueName, name: 'QueueName', description: 'Queue name' }),
    __metadata("design:type", String)
], QueueNameParamDto.prototype, "name", void 0);
class QueueCommandDto {
    command;
    force;
    static _OPENAPI_METADATA_FACTORY() {
        return { command: { required: true, enum: require("../enum").QueueCommand }, force: { required: false, type: () => Boolean } };
    }
}
exports.QueueCommandDto = QueueCommandDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.QueueCommand, name: 'QueueCommand', description: 'Queue command to execute' }),
    __metadata("design:type", String)
], QueueCommandDto.prototype, "command", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Force the command execution (if applicable)' }),
    __metadata("design:type", Boolean)
], QueueCommandDto.prototype, "force", void 0);
class QueueUpdateDto {
    isPaused;
    static _OPENAPI_METADATA_FACTORY() {
        return { isPaused: { required: false, type: () => Boolean } };
    }
}
exports.QueueUpdateDto = QueueUpdateDto;
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Whether to pause the queue' }),
    __metadata("design:type", Boolean)
], QueueUpdateDto.prototype, "isPaused", void 0);
class QueueDeleteDto {
    failed;
    static _OPENAPI_METADATA_FACTORY() {
        return { failed: { required: false, type: () => Boolean } };
    }
}
exports.QueueDeleteDto = QueueDeleteDto;
__decorate([
    (0, validation_1.ValidateBoolean)({
        optional: true,
        description: 'If true, will also remove failed jobs from the queue.',
        history: new decorators_1.HistoryBuilder().added('v2.4.0').alpha('v2.4.0'),
    }),
    __metadata("design:type", Boolean)
], QueueDeleteDto.prototype, "failed", void 0);
class QueueJobSearchDto {
    status;
    static _OPENAPI_METADATA_FACTORY() {
        return { status: { required: false, enum: require("../enum").QueueJobStatus, isArray: true } };
    }
}
exports.QueueJobSearchDto = QueueJobSearchDto;
__decorate([
    (0, validation_1.ValidateEnum)({
        enum: enum_1.QueueJobStatus,
        name: 'QueueJobStatus',
        optional: true,
        each: true,
        description: 'Filter jobs by status',
    }),
    __metadata("design:type", Array)
], QueueJobSearchDto.prototype, "status", void 0);
class QueueJobResponseDto {
    id;
    name;
    data;
    timestamp;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: false, type: () => String }, name: { required: true, enum: require("../enum").JobName }, data: { required: true, type: () => Object }, timestamp: { required: true, type: () => Number } };
    }
}
exports.QueueJobResponseDto = QueueJobResponseDto;
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Job ID' }),
    __metadata("design:type", String)
], QueueJobResponseDto.prototype, "id", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.JobName, name: 'JobName', description: 'Job name' }),
    __metadata("design:type", String)
], QueueJobResponseDto.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Job data payload', type: Object }),
    __metadata("design:type", Object)
], QueueJobResponseDto.prototype, "data", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Job creation timestamp' }),
    __metadata("design:type", Number)
], QueueJobResponseDto.prototype, "timestamp", void 0);
class QueueStatisticsDto {
    active;
    completed;
    failed;
    delayed;
    waiting;
    paused;
    static _OPENAPI_METADATA_FACTORY() {
        return { active: { required: true, type: () => Number }, completed: { required: true, type: () => Number }, failed: { required: true, type: () => Number }, delayed: { required: true, type: () => Number }, waiting: { required: true, type: () => Number }, paused: { required: true, type: () => Number } };
    }
}
exports.QueueStatisticsDto = QueueStatisticsDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Number of active jobs' }),
    __metadata("design:type", Number)
], QueueStatisticsDto.prototype, "active", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Number of completed jobs' }),
    __metadata("design:type", Number)
], QueueStatisticsDto.prototype, "completed", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Number of failed jobs' }),
    __metadata("design:type", Number)
], QueueStatisticsDto.prototype, "failed", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Number of delayed jobs' }),
    __metadata("design:type", Number)
], QueueStatisticsDto.prototype, "delayed", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Number of waiting jobs' }),
    __metadata("design:type", Number)
], QueueStatisticsDto.prototype, "waiting", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Number of paused jobs' }),
    __metadata("design:type", Number)
], QueueStatisticsDto.prototype, "paused", void 0);
class QueueResponseDto {
    name;
    isPaused;
    statistics;
    static _OPENAPI_METADATA_FACTORY() {
        return { name: { required: true, enum: require("../enum").QueueName }, isPaused: { required: true, type: () => Boolean }, statistics: { required: true, type: () => require("./queue.dto").QueueStatisticsDto } };
    }
}
exports.QueueResponseDto = QueueResponseDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.QueueName, name: 'QueueName', description: 'Queue name' }),
    __metadata("design:type", String)
], QueueResponseDto.prototype, "name", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Whether the queue is paused' }),
    __metadata("design:type", Boolean)
], QueueResponseDto.prototype, "isPaused", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", QueueStatisticsDto)
], QueueResponseDto.prototype, "statistics", void 0);
//# sourceMappingURL=queue.dto.js.map