"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapStack = exports.StackResponseDto = exports.StackUpdateDto = exports.StackSearchDto = exports.StackCreateDto = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const asset_response_dto_1 = require("./asset-response.dto");
const validation_1 = require("../validation");
class StackCreateDto {
    assetIds;
    static _OPENAPI_METADATA_FACTORY() {
        return { assetIds: { required: true, type: () => [String], minItems: 2 } };
    }
}
exports.StackCreateDto = StackCreateDto;
__decorate([
    (0, validation_1.ValidateUUID)({ each: true, description: 'Asset IDs (first becomes primary, min 2)' }),
    (0, class_validator_1.ArrayMinSize)(2),
    __metadata("design:type", Array)
], StackCreateDto.prototype, "assetIds", void 0);
class StackSearchDto {
    primaryAssetId;
    static _OPENAPI_METADATA_FACTORY() {
        return { primaryAssetId: { required: false, type: () => String } };
    }
}
exports.StackSearchDto = StackSearchDto;
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true, description: 'Filter by primary asset ID' }),
    __metadata("design:type", String)
], StackSearchDto.prototype, "primaryAssetId", void 0);
class StackUpdateDto {
    primaryAssetId;
    static _OPENAPI_METADATA_FACTORY() {
        return { primaryAssetId: { required: false, type: () => String } };
    }
}
exports.StackUpdateDto = StackUpdateDto;
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true, description: 'Primary asset ID' }),
    __metadata("design:type", String)
], StackUpdateDto.prototype, "primaryAssetId", void 0);
class StackResponseDto {
    id;
    primaryAssetId;
    assets;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, primaryAssetId: { required: true, type: () => String }, assets: { required: true, type: () => [require("./asset-response.dto").AssetResponseDto] } };
    }
}
exports.StackResponseDto = StackResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Stack ID' }),
    __metadata("design:type", String)
], StackResponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Primary asset ID' }),
    __metadata("design:type", String)
], StackResponseDto.prototype, "primaryAssetId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Stack assets' }),
    __metadata("design:type", Array)
], StackResponseDto.prototype, "assets", void 0);
const mapStack = (stack, { auth }) => {
    const primary = stack.assets.filter((asset) => asset.id === stack.primaryAssetId);
    const others = stack.assets.filter((asset) => asset.id !== stack.primaryAssetId);
    return {
        id: stack.id,
        primaryAssetId: stack.primaryAssetId,
        assets: [...primary, ...others].map((asset) => (0, asset_response_dto_1.mapAsset)(asset, { auth })),
    };
};
exports.mapStack = mapStack;
//# sourceMappingURL=stack.dto.js.map