"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkflowActionResponseDto = exports.WorkflowFilterResponseDto = exports.WorkflowResponseDto = exports.WorkflowUpdateDto = exports.WorkflowCreateDto = exports.WorkflowActionItemDto = exports.WorkflowFilterItemDto = void 0;
exports.mapWorkflowFilter = mapWorkflowFilter;
exports.mapWorkflowAction = mapWorkflowAction;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const enum_1 = require("../enum");
const validation_1 = require("../validation");
class WorkflowFilterItemDto {
    pluginFilterId;
    filterConfig;
    static _OPENAPI_METADATA_FACTORY() {
        return { pluginFilterId: { required: true, type: () => String, format: "uuid" }, filterConfig: { required: false, type: () => Object } };
    }
}
exports.WorkflowFilterItemDto = WorkflowFilterItemDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Plugin filter ID' }),
    (0, class_validator_1.IsUUID)(),
    __metadata("design:type", String)
], WorkflowFilterItemDto.prototype, "pluginFilterId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Filter configuration' }),
    (0, class_validator_1.IsObject)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", Object)
], WorkflowFilterItemDto.prototype, "filterConfig", void 0);
class WorkflowActionItemDto {
    pluginActionId;
    actionConfig;
    static _OPENAPI_METADATA_FACTORY() {
        return { pluginActionId: { required: true, type: () => String, format: "uuid" }, actionConfig: { required: false, type: () => Object } };
    }
}
exports.WorkflowActionItemDto = WorkflowActionItemDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Plugin action ID' }),
    (0, class_validator_1.IsUUID)(),
    __metadata("design:type", String)
], WorkflowActionItemDto.prototype, "pluginActionId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Action configuration' }),
    (0, class_validator_1.IsObject)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", Object)
], WorkflowActionItemDto.prototype, "actionConfig", void 0);
class WorkflowCreateDto {
    triggerType;
    name;
    description;
    enabled;
    filters;
    actions;
    static _OPENAPI_METADATA_FACTORY() {
        return { triggerType: { required: true, enum: require("../enum").PluginTriggerType }, name: { required: true, type: () => String }, description: { required: false, type: () => String }, enabled: { required: false, type: () => Boolean }, filters: { required: true, type: () => [require("./workflow.dto").WorkflowFilterItemDto] }, actions: { required: true, type: () => [require("./workflow.dto").WorkflowActionItemDto] } };
    }
}
exports.WorkflowCreateDto = WorkflowCreateDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.PluginTriggerType, name: 'PluginTriggerType', description: 'Workflow trigger type' }),
    __metadata("design:type", String)
], WorkflowCreateDto.prototype, "triggerType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Workflow name' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], WorkflowCreateDto.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Workflow description' }),
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], WorkflowCreateDto.prototype, "description", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Workflow enabled' }),
    __metadata("design:type", Boolean)
], WorkflowCreateDto.prototype, "enabled", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Workflow filters' }),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => WorkflowFilterItemDto),
    __metadata("design:type", Array)
], WorkflowCreateDto.prototype, "filters", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Workflow actions' }),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => WorkflowActionItemDto),
    __metadata("design:type", Array)
], WorkflowCreateDto.prototype, "actions", void 0);
class WorkflowUpdateDto {
    triggerType;
    name;
    description;
    enabled;
    filters;
    actions;
    static _OPENAPI_METADATA_FACTORY() {
        return { triggerType: { required: false, enum: require("../enum").PluginTriggerType }, name: { required: false, type: () => String }, description: { required: false, type: () => String }, enabled: { required: false, type: () => Boolean }, filters: { required: false, type: () => [require("./workflow.dto").WorkflowFilterItemDto] }, actions: { required: false, type: () => [require("./workflow.dto").WorkflowActionItemDto] } };
    }
}
exports.WorkflowUpdateDto = WorkflowUpdateDto;
__decorate([
    (0, validation_1.ValidateEnum)({
        enum: enum_1.PluginTriggerType,
        name: 'PluginTriggerType',
        optional: true,
        description: 'Workflow trigger type',
    }),
    __metadata("design:type", String)
], WorkflowUpdateDto.prototype, "triggerType", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Workflow name' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], WorkflowUpdateDto.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Workflow description' }),
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], WorkflowUpdateDto.prototype, "description", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Workflow enabled' }),
    __metadata("design:type", Boolean)
], WorkflowUpdateDto.prototype, "enabled", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Workflow filters' }),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => WorkflowFilterItemDto),
    (0, validation_1.Optional)(),
    __metadata("design:type", Array)
], WorkflowUpdateDto.prototype, "filters", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Workflow actions' }),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => WorkflowActionItemDto),
    (0, validation_1.Optional)(),
    __metadata("design:type", Array)
], WorkflowUpdateDto.prototype, "actions", void 0);
class WorkflowResponseDto {
    id;
    ownerId;
    triggerType;
    name;
    description;
    createdAt;
    enabled;
    filters;
    actions;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, ownerId: { required: true, type: () => String }, triggerType: { required: true, enum: require("../enum").PluginTriggerType }, name: { required: true, type: () => String, nullable: true }, description: { required: true, type: () => String }, createdAt: { required: true, type: () => String }, enabled: { required: true, type: () => Boolean }, filters: { required: true, type: () => [require("./workflow.dto").WorkflowFilterResponseDto] }, actions: { required: true, type: () => [require("./workflow.dto").WorkflowActionResponseDto] } };
    }
}
exports.WorkflowResponseDto = WorkflowResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Workflow ID' }),
    __metadata("design:type", String)
], WorkflowResponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Owner user ID' }),
    __metadata("design:type", String)
], WorkflowResponseDto.prototype, "ownerId", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.PluginTriggerType, name: 'PluginTriggerType', description: 'Workflow trigger type' }),
    __metadata("design:type", String)
], WorkflowResponseDto.prototype, "triggerType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Workflow name' }),
    __metadata("design:type", Object)
], WorkflowResponseDto.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Workflow description' }),
    __metadata("design:type", String)
], WorkflowResponseDto.prototype, "description", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Creation date' }),
    __metadata("design:type", String)
], WorkflowResponseDto.prototype, "createdAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Workflow enabled' }),
    __metadata("design:type", Boolean)
], WorkflowResponseDto.prototype, "enabled", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Workflow filters' }),
    __metadata("design:type", Array)
], WorkflowResponseDto.prototype, "filters", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Workflow actions' }),
    __metadata("design:type", Array)
], WorkflowResponseDto.prototype, "actions", void 0);
class WorkflowFilterResponseDto {
    id;
    workflowId;
    pluginFilterId;
    filterConfig;
    order;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, workflowId: { required: true, type: () => String }, pluginFilterId: { required: true, type: () => String }, filterConfig: { required: true, type: () => Object, nullable: true }, order: { required: true, type: () => Number } };
    }
}
exports.WorkflowFilterResponseDto = WorkflowFilterResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Filter ID' }),
    __metadata("design:type", String)
], WorkflowFilterResponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Workflow ID' }),
    __metadata("design:type", String)
], WorkflowFilterResponseDto.prototype, "workflowId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Plugin filter ID' }),
    __metadata("design:type", String)
], WorkflowFilterResponseDto.prototype, "pluginFilterId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Filter configuration' }),
    __metadata("design:type", Object)
], WorkflowFilterResponseDto.prototype, "filterConfig", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Filter order', type: 'number' }),
    __metadata("design:type", Number)
], WorkflowFilterResponseDto.prototype, "order", void 0);
class WorkflowActionResponseDto {
    id;
    workflowId;
    pluginActionId;
    actionConfig;
    order;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, workflowId: { required: true, type: () => String }, pluginActionId: { required: true, type: () => String }, actionConfig: { required: true, type: () => Object, nullable: true }, order: { required: true, type: () => Number } };
    }
}
exports.WorkflowActionResponseDto = WorkflowActionResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Action ID' }),
    __metadata("design:type", String)
], WorkflowActionResponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Workflow ID' }),
    __metadata("design:type", String)
], WorkflowActionResponseDto.prototype, "workflowId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Plugin action ID' }),
    __metadata("design:type", String)
], WorkflowActionResponseDto.prototype, "pluginActionId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Action configuration' }),
    __metadata("design:type", Object)
], WorkflowActionResponseDto.prototype, "actionConfig", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Action order', type: 'number' }),
    __metadata("design:type", Number)
], WorkflowActionResponseDto.prototype, "order", void 0);
function mapWorkflowFilter(filter) {
    return {
        id: filter.id,
        workflowId: filter.workflowId,
        pluginFilterId: filter.pluginFilterId,
        filterConfig: filter.filterConfig,
        order: filter.order,
    };
}
function mapWorkflowAction(action) {
    return {
        id: action.id,
        workflowId: action.workflowId,
        pluginActionId: action.pluginActionId,
        actionConfig: action.actionConfig,
        order: action.order,
    };
}
//# sourceMappingURL=workflow.dto.js.map