"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var MaintenanceAuthGuard_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MaintenanceAuthGuard = exports.MaintenanceAuth = exports.MaintenanceRoute = void 0;
const common_1 = require("@nestjs/common");
const core_1 = require("@nestjs/core");
const enum_1 = require("../enum");
const maintenance_worker_service_1 = require("./maintenance-worker.service");
const logging_repository_1 = require("../repositories/logging.repository");
const MaintenanceRoute = (options = {}) => {
    const decorators = [(0, common_1.SetMetadata)(enum_1.MetadataKey.AuthRoute, options)];
    return (0, common_1.applyDecorators)(...decorators);
};
exports.MaintenanceRoute = MaintenanceRoute;
exports.MaintenanceAuth = (0, common_1.createParamDecorator)((data, context) => {
    return context.switchToHttp().getRequest().auth;
});
let MaintenanceAuthGuard = MaintenanceAuthGuard_1 = class MaintenanceAuthGuard {
    logger;
    reflector;
    service;
    constructor(logger, reflector, service) {
        this.logger = logger;
        this.reflector = reflector;
        this.service = service;
        this.logger.setContext(MaintenanceAuthGuard_1.name);
    }
    async canActivate(context) {
        const targets = [context.getHandler()];
        const options = this.reflector.getAllAndOverride(enum_1.MetadataKey.AuthRoute, targets);
        if (!options) {
            return true;
        }
        const request = context.switchToHttp().getRequest();
        request.auth = await this.service.authenticate(request.headers);
        return true;
    }
};
exports.MaintenanceAuthGuard = MaintenanceAuthGuard;
exports.MaintenanceAuthGuard = MaintenanceAuthGuard = MaintenanceAuthGuard_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [logging_repository_1.LoggingRepository,
        core_1.Reflector,
        maintenance_worker_service_1.MaintenanceWorkerService])
], MaintenanceAuthGuard);
//# sourceMappingURL=maintenance-auth.guard.js.map