"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssetEditRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const nestjs_kysely_1 = require("nestjs-kysely");
const decorators_1 = require("../decorators");
let AssetEditRepository = class AssetEditRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    replaceAll(assetId, edits) {
        return this.db.transaction().execute(async (trx) => {
            await trx.deleteFrom('asset_edit').where('assetId', '=', assetId).execute();
            if (edits.length > 0) {
                return trx
                    .insertInto('asset_edit')
                    .values(edits.map((edit, i) => ({ assetId, sequence: i, ...edit })))
                    .returning(['action', 'parameters'])
                    .execute();
            }
            return [];
        });
    }
    getAll(assetId) {
        return this.db
            .selectFrom('asset_edit')
            .select(['action', 'parameters'])
            .where('assetId', '=', assetId)
            .orderBy('sequence', 'asc')
            .execute();
    }
};
exports.AssetEditRepository = AssetEditRepository;
__decorate([
    (0, decorators_1.GenerateSql)({
        params: [decorators_1.DummyValue.UUID],
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Array]),
    __metadata("design:returntype", Promise)
], AssetEditRepository.prototype, "replaceAll", null);
__decorate([
    (0, decorators_1.GenerateSql)({
        params: [decorators_1.DummyValue.UUID],
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], AssetEditRepository.prototype, "getAll", null);
exports.AssetEditRepository = AssetEditRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], AssetEditRepository);
//# sourceMappingURL=asset-edit.repository.js.map