import { Insertable, Kysely } from 'kysely';
import { AssetOcrResponseDto } from 'src/dtos/ocr.dto';
import { DB } from 'src/schema';
import { AssetOcrTable } from 'src/schema/tables/asset-ocr.table';
export declare class OcrRepository {
    private db;
    constructor(db: Kysely<DB>);
    getById(id: string): Promise<{
        id: string;
        assetId: string;
        text: string;
        isVisible: boolean;
        x1: number;
        y1: number;
        x2: number;
        y2: number;
        x3: number;
        y3: number;
        x4: number;
        y4: number;
        boxScore: number;
        textScore: number;
    } | undefined>;
    getByAssetId(id: string, options?: {
        isVisible?: boolean;
    }): Promise<{
        id: string;
        assetId: string;
        text: string;
        isVisible: boolean;
        x1: number;
        y1: number;
        x2: number;
        y2: number;
        x3: number;
        y3: number;
        x4: number;
        y4: number;
        boxScore: number;
        textScore: number;
    }[]>;
    deleteAll(): Promise<void>;
    upsert(assetId: string, ocrDataList: Insertable<AssetOcrTable>[], searchText: string): Promise<{
        dummy: unknown;
    }[]>;
    updateOcrVisibilities(assetId: string, visible: AssetOcrResponseDto[], hidden: AssetOcrResponseDto[]): Promise<void>;
}
