"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SharedLinkRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const postgres_1 = require("kysely/helpers/postgres");
const lodash_1 = __importDefault(require("lodash"));
const nestjs_kysely_1 = require("nestjs-kysely");
const database_1 = require("../database");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
let SharedLinkRepository = class SharedLinkRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    get(userId, id) {
        return this.db
            .selectFrom('shared_link')
            .selectAll('shared_link')
            .leftJoinLateral((eb) => eb
            .selectFrom('shared_link_asset')
            .whereRef('shared_link.id', '=', 'shared_link_asset.sharedLinkId')
            .innerJoin('asset', 'asset.id', 'shared_link_asset.assetId')
            .where('asset.deletedAt', 'is', null)
            .selectAll('asset')
            .innerJoinLateral((eb) => eb
            .selectFrom('asset_exif')
            .selectAll('asset_exif')
            .whereRef('asset_exif.assetId', '=', 'asset.id')
            .as('exifInfo'), (join) => join.onTrue())
            .select((eb) => eb.fn.toJson('exifInfo').as('exifInfo'))
            .orderBy('asset.fileCreatedAt', 'asc')
            .as('a'), (join) => join.onTrue())
            .leftJoinLateral((eb) => eb
            .selectFrom('album')
            .selectAll('album')
            .whereRef('album.id', '=', 'shared_link.albumId')
            .where('album.deletedAt', 'is', null)
            .leftJoin('album_asset', 'album_asset.albumId', 'album.id')
            .leftJoinLateral((eb) => eb
            .selectFrom('asset')
            .selectAll('asset')
            .whereRef('album_asset.assetId', '=', 'asset.id')
            .where('asset.deletedAt', 'is', null)
            .innerJoinLateral((eb) => eb
            .selectFrom('asset_exif')
            .selectAll('asset_exif')
            .whereRef('asset_exif.assetId', '=', 'asset.id')
            .as('exifInfo'), (join) => join.onTrue())
            .select((eb) => eb.fn.toJson(eb.table('exifInfo')).as('exifInfo'))
            .orderBy('asset.fileCreatedAt', 'asc')
            .as('assets'), (join) => join.onTrue())
            .innerJoinLateral((eb) => eb
            .selectFrom('user')
            .selectAll('user')
            .whereRef('user.id', '=', 'album.ownerId')
            .where('user.deletedAt', 'is', null)
            .as('owner'), (join) => join.onTrue())
            .select((eb) => eb.fn
            .coalesce(eb.fn
            .jsonAgg('assets')
            .orderBy('assets.fileCreatedAt', 'asc')
            .filterWhere('assets.id', 'is not', null), (0, kysely_1.sql) `'[]'`)
            .as('assets'))
            .select((eb) => eb.fn.toJson('owner').as('owner'))
            .groupBy(['album.id', (0, kysely_1.sql) `"owner".*`])
            .as('album'), (join) => join.onTrue())
            .select((eb) => eb.fn
            .coalesce(eb.fn.jsonAgg('a').filterWhere('a.id', 'is not', null), (0, kysely_1.sql) `'[]'`)
            .$castTo()
            .as('assets'))
            .groupBy(['shared_link.id', (0, kysely_1.sql) `"album".*`])
            .select((eb) => eb.fn.toJson('album').$castTo().as('album'))
            .where('shared_link.id', '=', id)
            .where('shared_link.userId', '=', userId)
            .where((eb) => eb.or([eb('shared_link.type', '=', enum_1.SharedLinkType.Individual), eb('album.id', 'is not', null)]))
            .orderBy('shared_link.createdAt', 'desc')
            .executeTakeFirst();
    }
    getAll({ userId, id, albumId }) {
        return this.db
            .selectFrom('shared_link')
            .selectAll('shared_link')
            .where('shared_link.userId', '=', userId)
            .leftJoin('shared_link_asset', 'shared_link_asset.sharedLinkId', 'shared_link.id')
            .leftJoinLateral((eb) => eb
            .selectFrom('asset')
            .select((eb) => eb.fn.jsonAgg('asset').as('assets'))
            .whereRef('asset.id', '=', 'shared_link_asset.assetId')
            .where('asset.deletedAt', 'is', null)
            .as('assets'), (join) => join.onTrue())
            .select('assets.assets')
            .$narrowType()
            .leftJoinLateral((eb) => eb
            .selectFrom('album')
            .selectAll('album')
            .whereRef('album.id', '=', 'shared_link.albumId')
            .innerJoinLateral((eb) => eb
            .selectFrom('user')
            .select([
            'user.id',
            'user.email',
            'user.createdAt',
            'user.profileImagePath',
            'user.isAdmin',
            'user.shouldChangePassword',
            'user.deletedAt',
            'user.oauthId',
            'user.updatedAt',
            'user.storageLabel',
            'user.name',
            'user.quotaSizeInBytes',
            'user.quotaUsageInBytes',
            'user.status',
            'user.profileChangedAt',
        ])
            .whereRef('user.id', '=', 'album.ownerId')
            .where('user.deletedAt', 'is', null)
            .as('owner'), (join) => join.onTrue())
            .select((eb) => eb.fn.toJson('owner').as('owner'))
            .where('album.deletedAt', 'is', null)
            .as('album'), (join) => join.onTrue())
            .select((eb) => eb.fn.toJson('album').$castTo().as('album'))
            .where((eb) => eb.or([eb('shared_link.type', '=', enum_1.SharedLinkType.Individual), eb('album.id', 'is not', null)]))
            .$if(!!albumId, (eb) => eb.where('shared_link.albumId', '=', albumId))
            .$if(!!id, (eb) => eb.where('shared_link.id', '=', id))
            .orderBy('shared_link.createdAt', 'desc')
            .distinctOn(['shared_link.createdAt'])
            .execute();
    }
    getByKey(key) {
        return this.authBuilder().where('shared_link.key', '=', key).executeTakeFirst();
    }
    getBySlug(slug) {
        return this.authBuilder().where('shared_link.slug', '=', slug).executeTakeFirst();
    }
    authBuilder() {
        return this.db
            .selectFrom('shared_link')
            .leftJoin('album', 'album.id', 'shared_link.albumId')
            .where('album.deletedAt', 'is', null)
            .select((eb) => [
            ...database_1.columns.authSharedLink,
            (0, postgres_1.jsonObjectFrom)(eb.selectFrom('user').select(database_1.columns.authUser).whereRef('user.id', '=', 'shared_link.userId')).as('user'),
        ])
            .where((eb) => eb.or([eb('shared_link.type', '=', enum_1.SharedLinkType.Individual), eb('album.id', 'is not', null)]));
    }
    async create(entity) {
        const { id } = await this.db
            .insertInto('shared_link')
            .values(lodash_1.default.omit(entity, 'assetIds'))
            .returningAll()
            .executeTakeFirstOrThrow();
        if (entity.assetIds && entity.assetIds.length > 0) {
            await this.db
                .insertInto('shared_link_asset')
                .values(entity.assetIds.map((assetId) => ({ assetId, sharedLinkId: id })))
                .execute();
        }
        return this.getSharedLinks(id);
    }
    async update(entity) {
        const { id } = await this.db
            .updateTable('shared_link')
            .set(lodash_1.default.omit(entity, 'assets', 'album', 'assetIds'))
            .where('shared_link.id', '=', entity.id)
            .returningAll()
            .executeTakeFirstOrThrow();
        if (entity.assetIds && entity.assetIds.length > 0) {
            await this.db
                .insertInto('shared_link_asset')
                .values(entity.assetIds.map((assetId) => ({ assetId, sharedLinkId: id })))
                .execute();
        }
        return this.getSharedLinks(id);
    }
    async remove(id) {
        await this.db.deleteFrom('shared_link').where('shared_link.id', '=', id).execute();
    }
    getSharedLinks(id) {
        return this.db
            .selectFrom('shared_link')
            .selectAll('shared_link')
            .where('shared_link.id', '=', id)
            .leftJoin('shared_link_asset', 'shared_link_asset.sharedLinkId', 'shared_link.id')
            .leftJoinLateral((eb) => eb
            .selectFrom('asset')
            .whereRef('asset.id', '=', 'shared_link_asset.assetId')
            .selectAll('asset')
            .innerJoinLateral((eb) => eb.selectFrom('asset_exif').whereRef('asset_exif.assetId', '=', 'asset.id').selectAll().as('exif'), (join) => join.onTrue())
            .as('assets'), (join) => join.onTrue())
            .select((eb) => eb.fn
            .coalesce(eb.fn.jsonAgg('assets').filterWhere('assets.id', 'is not', null), (0, kysely_1.sql) `'[]'`)
            .$castTo()
            .as('assets'))
            .groupBy('shared_link.id')
            .executeTakeFirstOrThrow();
    }
};
exports.SharedLinkRepository = SharedLinkRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], SharedLinkRepository.prototype, "get", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [{ userId: decorators_1.DummyValue.UUID, albumId: decorators_1.DummyValue.UUID }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], SharedLinkRepository.prototype, "getAll", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.BUFFER] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Buffer]),
    __metadata("design:returntype", void 0)
], SharedLinkRepository.prototype, "getByKey", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.BUFFER] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SharedLinkRepository.prototype, "getBySlug", null);
exports.SharedLinkRepository = SharedLinkRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], SharedLinkRepository);
//# sourceMappingURL=shared-link.repository.js.map