"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TelemetryRepository = exports.teardownTelemetry = exports.bootstrapTelemetry = exports.MetricGroupRepository = void 0;
const common_1 = require("@nestjs/common");
const core_1 = require("@nestjs/core");
const context_async_hooks_1 = require("@opentelemetry/context-async-hooks");
const exporter_prometheus_1 = require("@opentelemetry/exporter-prometheus");
const instrumentation_http_1 = require("@opentelemetry/instrumentation-http");
const instrumentation_ioredis_1 = require("@opentelemetry/instrumentation-ioredis");
const instrumentation_nestjs_core_1 = require("@opentelemetry/instrumentation-nestjs-core");
const instrumentation_pg_1 = require("@opentelemetry/instrumentation-pg");
const resources_1 = require("@opentelemetry/resources");
const sdk_metrics_1 = require("@opentelemetry/sdk-metrics");
const sdk_node_1 = require("@opentelemetry/sdk-node");
const semantic_conventions_1 = require("@opentelemetry/semantic-conventions");
const lodash_1 = require("lodash");
const nestjs_otel_1 = require("nestjs-otel");
const opentelemetry_utils_1 = require("nestjs-otel/lib/opentelemetry.utils");
const constants_1 = require("../constants");
const enum_1 = require("../enum");
const config_repository_1 = require("./config.repository");
const logging_repository_1 = require("./logging.repository");
class MetricGroupRepository {
    metricService;
    enabled = false;
    constructor(metricService) {
        this.metricService = metricService;
    }
    addToCounter(name, value, options) {
        if (this.enabled) {
            this.metricService.getCounter(name, options).add(value);
        }
    }
    addToGauge(name, value, options) {
        if (this.enabled) {
            this.metricService.getUpDownCounter(name, options).add(value);
        }
    }
    addToHistogram(name, value, options) {
        if (this.enabled) {
            this.metricService.getHistogram(name, options).record(value);
        }
    }
    configure(options) {
        this.enabled = options.enabled;
        return this;
    }
}
exports.MetricGroupRepository = MetricGroupRepository;
const aggregationBoundaries = [
    0.1, 0.25, 0.5, 0.75, 1, 2.5, 5, 7.5, 10, 25, 50, 75, 100, 250, 500, 750, 1000, 2500, 5000, 7500, 10_000,
];
let instance;
const bootstrapTelemetry = (port) => {
    if (instance) {
        throw new Error('OpenTelemetry SDK already started');
    }
    instance = new sdk_node_1.NodeSDK({
        resource: (0, resources_1.resourceFromAttributes)({
            [semantic_conventions_1.ATTR_SERVICE_NAME]: `immich`,
            [semantic_conventions_1.ATTR_SERVICE_VERSION]: constants_1.serverVersion.toString(),
        }),
        metricReader: new exporter_prometheus_1.PrometheusExporter({ port }),
        contextManager: new context_async_hooks_1.AsyncLocalStorageContextManager(),
        instrumentations: [
            new instrumentation_http_1.HttpInstrumentation(),
            new instrumentation_ioredis_1.IORedisInstrumentation(),
            new instrumentation_nestjs_core_1.NestInstrumentation(),
            new instrumentation_pg_1.PgInstrumentation(),
        ],
        views: [
            {
                instrumentName: '*',
                instrumentUnit: 'ms',
                aggregation: {
                    type: sdk_metrics_1.AggregationType.EXPLICIT_BUCKET_HISTOGRAM,
                    options: { boundaries: aggregationBoundaries },
                },
            },
        ],
    });
    instance.start();
};
exports.bootstrapTelemetry = bootstrapTelemetry;
const teardownTelemetry = async () => {
    if (instance) {
        await instance.shutdown();
        instance = undefined;
    }
};
exports.teardownTelemetry = teardownTelemetry;
let TelemetryRepository = class TelemetryRepository {
    metricService;
    reflect;
    configRepository;
    logger;
    api;
    host;
    jobs;
    repo;
    constructor(metricService, reflect, configRepository, logger) {
        this.metricService = metricService;
        this.reflect = reflect;
        this.configRepository = configRepository;
        this.logger = logger;
        const { telemetry } = this.configRepository.getEnv();
        const { metrics } = telemetry;
        this.api = new MetricGroupRepository(metricService).configure({ enabled: metrics.has(enum_1.ImmichTelemetry.Api) });
        this.host = new MetricGroupRepository(metricService).configure({ enabled: metrics.has(enum_1.ImmichTelemetry.Host) });
        this.jobs = new MetricGroupRepository(metricService).configure({ enabled: metrics.has(enum_1.ImmichTelemetry.Job) });
        this.repo = new MetricGroupRepository(metricService).configure({ enabled: metrics.has(enum_1.ImmichTelemetry.Repo) });
    }
    setup({ repositories }) {
        const { telemetry } = this.configRepository.getEnv();
        const { metrics } = telemetry;
        if (!metrics.has(enum_1.ImmichTelemetry.Repo)) {
            return;
        }
        for (const Repository of repositories) {
            const isEnabled = this.reflect.get(enum_1.MetadataKey.TelemetryEnabled, Repository) ?? true;
            if (!isEnabled) {
                this.logger.debug(`Telemetry disabled for ${Repository.name}`);
                continue;
            }
            this.wrap(Repository);
        }
    }
    wrap(Repository) {
        const className = Repository.name;
        const descriptors = Object.getOwnPropertyDescriptors(Repository.prototype);
        const unit = 'ms';
        for (const [propName, descriptor] of Object.entries(descriptors)) {
            const isMethod = typeof descriptor.value == 'function' && propName !== 'constructor';
            if (!isMethod) {
                continue;
            }
            const method = descriptor.value;
            const propertyName = (0, lodash_1.snakeCase)(String(propName));
            const metricName = `${(0, lodash_1.snakeCase)(className).replaceAll(/_(?=(repository)|(controller)|(provider)|(service)|(module))/g, '.')}.${propertyName}.duration`;
            const histogram = this.metricService.getHistogram(metricName, {
                prefix: 'immich',
                description: `The elapsed time in ${unit} for the ${(0, lodash_1.startCase)(className)} to ${propertyName.toLowerCase()}`,
                unit,
                valueType: sdk_node_1.contextBase.ValueType.DOUBLE,
            });
            descriptor.value = function (...args) {
                const start = performance.now();
                const result = method.apply(this, args);
                void Promise.resolve(result)
                    .then(() => histogram.record(performance.now() - start, {}))
                    .catch(() => {
                });
                return result;
            };
            (0, opentelemetry_utils_1.copyMetadataFromFunctionToFunction)(method, descriptor.value);
            Object.defineProperty(Repository.prototype, propName, descriptor);
        }
    }
};
exports.TelemetryRepository = TelemetryRepository;
exports.TelemetryRepository = TelemetryRepository = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [nestjs_otel_1.MetricService,
        core_1.Reflector,
        config_repository_1.ConfigRepository,
        logging_repository_1.LoggingRepository])
], TelemetryRepository);
//# sourceMappingURL=telemetry.repository.js.map