"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const postgres_1 = require("kysely/helpers/postgres");
const luxon_1 = require("luxon");
const nestjs_kysely_1 = require("nestjs-kysely");
const database_1 = require("../database");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
const database_2 = require("../utils/database");
const withMetadata = (eb) => {
    return (0, postgres_1.jsonArrayFrom)(eb
        .selectFrom('user_metadata')
        .select(['user_metadata.key', 'user_metadata.value'])
        .whereRef('user.id', '=', 'user_metadata.userId')).as('metadata');
};
let UserRepository = class UserRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    get(userId, options) {
        options = options || {};
        return this.db
            .selectFrom('user')
            .select(database_1.columns.userAdmin)
            .select(withMetadata)
            .where('user.id', '=', userId)
            .$if(!options.withDeleted, (eb) => eb.where('user.deletedAt', 'is', null))
            .executeTakeFirst();
    }
    getMetadata(userId) {
        return this.db
            .selectFrom('user_metadata')
            .select(['key', 'value'])
            .where('user_metadata.userId', '=', userId)
            .execute();
    }
    getAdmin() {
        return this.db
            .selectFrom('user')
            .select(database_1.columns.userAdmin)
            .select(withMetadata)
            .where('user.isAdmin', '=', true)
            .where('user.deletedAt', 'is', null)
            .executeTakeFirst();
    }
    getFileSamples() {
        return this.db
            .selectFrom('user')
            .select(['id', 'profileImagePath'])
            .where('profileImagePath', '!=', kysely_1.sql.lit(''))
            .limit(kysely_1.sql.lit(3))
            .execute();
    }
    async hasAdmin() {
        const admin = await this.db
            .selectFrom('user')
            .select('user.id')
            .where('user.isAdmin', '=', true)
            .where('user.deletedAt', 'is', null)
            .executeTakeFirst();
        return !!admin;
    }
    getForPinCode(id) {
        return this.db
            .selectFrom('user')
            .select(['user.pinCode', 'user.password'])
            .where('user.id', '=', id)
            .where('user.deletedAt', 'is', null)
            .executeTakeFirstOrThrow();
    }
    getForChangePassword(id) {
        return this.db
            .selectFrom('user')
            .select(['user.id', 'user.password'])
            .where('user.id', '=', id)
            .where('user.deletedAt', 'is', null)
            .executeTakeFirstOrThrow();
    }
    getByEmail(email, options) {
        return this.db
            .selectFrom('user')
            .select(database_1.columns.userAdmin)
            .select(withMetadata)
            .$if(!!options?.withPassword, (eb) => eb.select('password'))
            .where('email', '=', email)
            .where('user.deletedAt', 'is', null)
            .executeTakeFirst();
    }
    getByStorageLabel(storageLabel) {
        return this.db
            .selectFrom('user')
            .select(database_1.columns.userAdmin)
            .where('user.storageLabel', '=', storageLabel)
            .where('user.deletedAt', 'is', null)
            .executeTakeFirst();
    }
    getByOAuthId(oauthId) {
        return this.db
            .selectFrom('user')
            .select(database_1.columns.userAdmin)
            .select(withMetadata)
            .where('user.oauthId', '=', oauthId)
            .where('user.deletedAt', 'is', null)
            .executeTakeFirst();
    }
    getDeletedAfter(target) {
        return this.db.selectFrom('user').select(['id']).where('user.deletedAt', '<', target.toJSDate()).execute();
    }
    getList({ id, withDeleted } = {}) {
        return this.db
            .selectFrom('user')
            .select(database_1.columns.userAdmin)
            .select(withMetadata)
            .$if(!withDeleted, (eb) => eb.where('user.deletedAt', 'is', null))
            .$if(!!id, (eb) => eb.where('user.id', '=', id))
            .orderBy('createdAt', 'desc')
            .execute();
    }
    async create(dto) {
        return this.db
            .insertInto('user')
            .values(dto)
            .returning(database_1.columns.userAdmin)
            .returning(withMetadata)
            .executeTakeFirstOrThrow();
    }
    update(id, dto) {
        return this.db
            .updateTable('user')
            .set(dto)
            .where('user.id', '=', (0, database_2.asUuid)(id))
            .where('user.deletedAt', 'is', null)
            .returning(database_1.columns.userAdmin)
            .returning(withMetadata)
            .executeTakeFirstOrThrow();
    }
    async updateAll(dto) {
        await this.db.updateTable('user').set(dto).execute();
    }
    restore(id) {
        return this.db
            .updateTable('user')
            .set({ status: enum_1.UserStatus.Active, deletedAt: null })
            .where('user.id', '=', (0, database_2.asUuid)(id))
            .returning(database_1.columns.userAdmin)
            .returning(withMetadata)
            .executeTakeFirstOrThrow();
    }
    async upsertMetadata(id, { key, value }) {
        await this.db
            .insertInto('user_metadata')
            .values({ userId: id, key, value })
            .onConflict((oc) => oc.columns(['userId', 'key']).doUpdateSet({
            key,
            value,
        }))
            .execute();
    }
    async deleteMetadata(id, key) {
        await this.db.deleteFrom('user_metadata').where('userId', '=', id).where('key', '=', key).execute();
    }
    delete(user, hard) {
        return hard
            ? this.db.deleteFrom('user').where('id', '=', user.id).execute()
            : this.db.updateTable('user').set({ deletedAt: new Date() }).where('id', '=', user.id).execute();
    }
    getUserStats() {
        return this.db
            .selectFrom('user')
            .leftJoin('asset', (join) => join.onRef('asset.ownerId', '=', 'user.id').on('asset.deletedAt', 'is', null))
            .leftJoin('asset_exif', 'asset_exif.assetId', 'asset.id')
            .select(['user.id as userId', 'user.name as userName', 'user.quotaSizeInBytes'])
            .select((eb) => [
            eb.fn
                .countAll()
                .filterWhere((eb) => eb.and([
                eb('asset.type', '=', kysely_1.sql.lit(enum_1.AssetType.Image)),
                eb('asset.visibility', '!=', kysely_1.sql.lit(enum_1.AssetVisibility.Hidden)),
            ]))
                .as('photos'),
            eb.fn
                .countAll()
                .filterWhere((eb) => eb.and([
                eb('asset.type', '=', kysely_1.sql.lit(enum_1.AssetType.Video)),
                eb('asset.visibility', '!=', kysely_1.sql.lit(enum_1.AssetVisibility.Hidden)),
            ]))
                .as('videos'),
            eb.fn
                .coalesce(eb.fn.sum('asset_exif.fileSizeInByte').filterWhere('asset.libraryId', 'is', null), eb.lit(0))
                .as('usage'),
            eb.fn
                .coalesce(eb.fn
                .sum('asset_exif.fileSizeInByte')
                .filterWhere((eb) => eb.and([eb('asset.libraryId', 'is', null), eb('asset.type', '=', kysely_1.sql.lit(enum_1.AssetType.Image))])), eb.lit(0))
                .as('usagePhotos'),
            eb.fn
                .coalesce(eb.fn
                .sum('asset_exif.fileSizeInByte')
                .filterWhere((eb) => eb.and([eb('asset.libraryId', 'is', null), eb('asset.type', '=', kysely_1.sql.lit(enum_1.AssetType.Video))])), eb.lit(0))
                .as('usageVideos'),
        ])
            .groupBy('user.id')
            .orderBy('user.createdAt', 'asc')
            .execute();
    }
    async getCount() {
        const result = await this.db
            .selectFrom('user')
            .select((eb) => eb.fn.countAll().as('count'))
            .where('user.deletedAt', 'is', null)
            .executeTakeFirstOrThrow();
        return Number(result.count);
    }
    async updateUsage(id, delta) {
        await this.db
            .updateTable('user')
            .set({ quotaUsageInBytes: (0, kysely_1.sql) `"quotaUsageInBytes" + ${delta}`, updatedAt: new Date() })
            .where('id', '=', (0, database_2.asUuid)(id))
            .where('user.deletedAt', 'is', null)
            .execute();
    }
    async syncUsage(id) {
        const query = this.db
            .updateTable('user')
            .set({
            quotaUsageInBytes: (eb) => eb
                .selectFrom('asset')
                .leftJoin('asset_exif', 'asset_exif.assetId', 'asset.id')
                .select((eb) => eb.fn.coalesce(eb.fn.sum('asset_exif.fileSizeInByte'), eb.lit(0)).as('usage'))
                .where('asset.libraryId', 'is', null)
                .where('asset.ownerId', '=', eb.ref('user.id')),
            updatedAt: new Date(),
        })
            .where('user.deletedAt', 'is', null)
            .$if(id != undefined, (eb) => eb.where('user.id', '=', (0, database_2.asUuid)(id)));
        await query.execute();
    }
};
exports.UserRepository = UserRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.BOOLEAN] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], UserRepository.prototype, "get", null);
__decorate([
    (0, decorators_1.GenerateSql)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], UserRepository.prototype, "getAdmin", null);
__decorate([
    (0, decorators_1.GenerateSql)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], UserRepository.prototype, "getFileSamples", null);
__decorate([
    (0, decorators_1.GenerateSql)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], UserRepository.prototype, "hasAdmin", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], UserRepository.prototype, "getForPinCode", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], UserRepository.prototype, "getForChangePassword", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.EMAIL] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], UserRepository.prototype, "getByEmail", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.STRING] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], UserRepository.prototype, "getByStorageLabel", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.STRING] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], UserRepository.prototype, "getByOAuthId", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [luxon_1.DateTime.now().minus({ years: 1 })] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [luxon_1.DateTime]),
    __metadata("design:returntype", void 0)
], UserRepository.prototype, "getDeletedAfter", null);
__decorate([
    (0, decorators_1.GenerateSql)({ name: 'with deleted', params: [{ withDeleted: true }] }, { name: 'without deleted', params: [{ withDeleted: false }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], UserRepository.prototype, "getList", null);
__decorate([
    (0, decorators_1.GenerateSql)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], UserRepository.prototype, "getUserStats", null);
__decorate([
    (0, decorators_1.GenerateSql)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], UserRepository.prototype, "getCount", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.NUMBER] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", Promise)
], UserRepository.prototype, "updateUsage", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], UserRepository.prototype, "syncUsage", null);
exports.UserRepository = UserRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], UserRepository);
//# sourceMappingURL=user.repository.js.map