"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.up = up;
exports.down = down;
const kysely_1 = require("kysely");
const enum_1 = require("../../enum");
async function up(db) {
    await (0, kysely_1.sql) `INSERT INTO user_metadata SELECT id, ${enum_1.UserMetadataKey.Onboarding}, '{"isOnboarded": true}' FROM users
    ON CONFLICT ("userId", key) DO NOTHING
  `.execute(db);
}
async function down(db) {
    await (0, kysely_1.sql) `DELETE FROM user_metadata WHERE key = ${enum_1.UserMetadataKey.Onboarding}`.execute(db);
}
//# sourceMappingURL=1749067526135-UserOnboardingDefault.js.map