import { PluginContext } from 'src/enum';
import { Generated, Timestamp } from 'src/sql-tools';
import type { JSONSchema } from 'src/types/plugin-schema.types';
export declare class PluginTable {
    id: Generated<string>;
    name: string;
    title: string;
    description: string;
    author: string;
    version: string;
    wasmPath: string;
    createdAt: Generated<Timestamp>;
    updatedAt: Generated<Timestamp>;
}
export declare class PluginFilterTable {
    id: Generated<string>;
    pluginId: string;
    methodName: string;
    title: string;
    description: string;
    supportedContexts: Generated<PluginContext[]>;
    schema: JSONSchema | null;
}
export declare class PluginActionTable {
    id: Generated<string>;
    pluginId: string;
    methodName: string;
    title: string;
    description: string;
    supportedContexts: Generated<PluginContext[]>;
    schema: JSONSchema | null;
}
