"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupService = void 0;
const common_1 = require("@nestjs/common");
const node_path_1 = __importDefault(require("node:path"));
const storage_core_1 = require("../cores/storage.core");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
const base_service_1 = require("./base.service");
const database_backups_1 = require("../utils/database-backups");
const misc_1 = require("../utils/misc");
let BackupService = class BackupService extends base_service_1.BaseService {
    backupLock = false;
    async onConfigInit({ newConfig: { backup: { database }, }, }) {
        this.backupLock = await this.databaseRepository.tryLock(enum_1.DatabaseLock.BackupDatabase);
        if (this.backupLock) {
            this.cronRepository.create({
                name: 'backupDatabase',
                expression: database.cronExpression,
                onTick: () => (0, misc_1.handlePromiseError)(this.jobRepository.queue({ name: enum_1.JobName.DatabaseBackup }), this.logger),
                start: database.enabled,
            });
        }
    }
    onConfigUpdate({ newConfig: { backup } }) {
        if (!this.backupLock) {
            return;
        }
        this.cronRepository.update({
            name: 'backupDatabase',
            expression: backup.database.cronExpression,
            start: backup.database.enabled,
        });
    }
    async cleanupDatabaseBackups() {
        this.logger.debug(`Database Backup Cleanup Started`);
        const { backup: { database: config }, } = await this.getConfig({ withCache: false });
        const backupsFolder = storage_core_1.StorageCore.getBaseFolder(enum_1.StorageFolder.Backups);
        const files = await this.storageRepository.readdir(backupsFolder);
        const backups = files
            .filter((filename) => (0, database_backups_1.isValidDatabaseRoutineBackupName)(filename))
            .toSorted()
            .toReversed();
        const failedBackups = files.filter((filename) => (0, database_backups_1.isFailedDatabaseBackupName)(filename));
        const toDelete = backups.slice(config.keepLastAmount);
        toDelete.push(...failedBackups);
        for (const file of toDelete) {
            await this.storageRepository.unlink(node_path_1.default.join(backupsFolder, file));
        }
        this.logger.debug(`Database Backup Cleanup Finished, deleted ${toDelete.length} backups`);
    }
    async handleBackupDatabase() {
        try {
            await (0, database_backups_1.createDatabaseBackup)(this.backupRepos);
        }
        catch (error) {
            if (error instanceof database_backups_1.UnsupportedPostgresError) {
                return enum_1.JobStatus.Failed;
            }
            throw error;
        }
        await this.cleanupDatabaseBackups();
        return enum_1.JobStatus.Success;
    }
    get backupRepos() {
        return {
            logger: this.logger,
            storage: this.storageRepository,
            config: this.configRepository,
            process: this.processRepository,
            database: this.databaseRepository,
        };
    }
};
exports.BackupService = BackupService;
__decorate([
    (0, decorators_1.OnEvent)({ name: 'ConfigInit', workers: [enum_1.ImmichWorker.Microservices] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], BackupService.prototype, "onConfigInit", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'ConfigUpdate', server: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], BackupService.prototype, "onConfigUpdate", null);
__decorate([
    (0, decorators_1.OnJob)({ name: enum_1.JobName.DatabaseBackup, queue: enum_1.QueueName.BackupDatabase }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], BackupService.prototype, "handleBackupDatabase", null);
exports.BackupService = BackupService = __decorate([
    (0, common_1.Injectable)()
], BackupService);
//# sourceMappingURL=backup.service.js.map