"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseBackupService = void 0;
const common_1 = require("@nestjs/common");
const base_service_1 = require("./base.service");
const database_backups_1 = require("../utils/database-backups");
let DatabaseBackupService = class DatabaseBackupService extends base_service_1.BaseService {
    async listBackups() {
        const backups = await (0, database_backups_1.listDatabaseBackups)(this.backupRepos);
        return { backups };
    }
    deleteBackup(files) {
        return (0, database_backups_1.deleteDatabaseBackup)(this.backupRepos, files);
    }
    async uploadBackup(file) {
        return (0, database_backups_1.uploadDatabaseBackup)(this.backupRepos, file);
    }
    downloadBackup(fileName) {
        return (0, database_backups_1.downloadDatabaseBackup)(fileName);
    }
    get backupRepos() {
        return {
            logger: this.logger,
            storage: this.storageRepository,
            config: this.configRepository,
            process: this.processRepository,
            database: this.databaseRepository,
        };
    }
};
exports.DatabaseBackupService = DatabaseBackupService;
exports.DatabaseBackupService = DatabaseBackupService = __decorate([
    (0, common_1.Injectable)()
], DatabaseBackupService);
//# sourceMappingURL=database-backup.service.js.map