"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compareTables = void 0;
const column_comparer_1 = require("./column.comparer");
const constraint_comparer_1 = require("./constraint.comparer");
const index_comparer_1 = require("./index.comparer");
const trigger_comparer_1 = require("./trigger.comparer");
const helpers_1 = require("../helpers");
const types_1 = require("../types");
exports.compareTables = {
    onMissing: (source) => [
        {
            type: 'TableCreate',
            table: source,
            reason: types_1.Reason.MissingInTarget,
        },
    ],
    onExtra: (target) => [
        {
            type: 'TableDrop',
            tableName: target.name,
            reason: types_1.Reason.MissingInSource,
        },
    ],
    onCompare: (source, target) => compareTable(source, target),
};
const compareTable = (source, target) => {
    return [
        ...(0, helpers_1.compare)(source.columns, target.columns, {}, column_comparer_1.compareColumns),
        ...(0, helpers_1.compare)(source.indexes, target.indexes, {}, index_comparer_1.compareIndexes),
        ...(0, helpers_1.compare)(source.constraints, target.constraints, {}, constraint_comparer_1.compareConstraints),
        ...(0, helpers_1.compare)(source.triggers, target.triggers, {}, trigger_comparer_1.compareTriggers),
    ];
};
//# sourceMappingURL=table.comparer.js.map