"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.processColumns = void 0;
const helpers_1 = require("../helpers");
const processColumns = (ctx, items) => {
    for (const { type, item: { object, propertyName, options }, } of items.filter((item) => item.type === 'column' || item.type === 'foreignKeyColumn')) {
        const table = ctx.getTableByObject(object.constructor);
        if (!table) {
            ctx.warnMissingTable(type === 'column' ? '@Column' : '@ForeignKeyColumn', object, propertyName);
            continue;
        }
        const columnName = options.name ?? ctx.getNameFor({ type: 'column', name: String(propertyName) });
        const existingColumn = table.columns.find((column) => column.name === columnName);
        if (existingColumn) {
            continue;
        }
        let defaultValue = (0, helpers_1.fromColumnValue)(options.default);
        let nullable = options.nullable ?? false;
        if (defaultValue === null) {
            nullable = true;
            defaultValue = undefined;
        }
        const isEnum = !!options.enum;
        ctx.addColumn(table, {
            name: columnName,
            tableName: table.name,
            primary: options.primary ?? false,
            default: defaultValue,
            nullable,
            isArray: options.array ?? false,
            length: options.length,
            type: isEnum ? 'enum' : options.type || 'character varying',
            enumName: isEnum ? options.enum.name : undefined,
            comment: options.comment,
            storage: options.storage,
            identity: options.identity,
            synchronize: options.synchronize ?? true,
        }, options, propertyName);
    }
};
exports.processColumns = processColumns;
//# sourceMappingURL=column.processor.js.map