"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.schemaFromCode = void 0;
const processor_context_1 = require("./contexts/processor-context");
const processors_1 = require("./processors");
const register_1 = require("./register");
const types_1 = require("./types");
const schemaFromCode = (options = {}) => {
    try {
        const ctx = new processor_context_1.ProcessorContext(options);
        const items = (0, register_1.getRegisteredItems)();
        for (const processor of processors_1.processors) {
            processor(ctx, items);
        }
        if (ctx.options.overrides) {
            ctx.tables.push({
                name: ctx.overrideTableName,
                columns: [
                    {
                        name: 'name',
                        tableName: ctx.overrideTableName,
                        primary: true,
                        type: 'character varying',
                        nullable: false,
                        isArray: false,
                        synchronize: true,
                    },
                    {
                        name: 'value',
                        tableName: ctx.overrideTableName,
                        primary: false,
                        type: 'jsonb',
                        nullable: false,
                        isArray: false,
                        synchronize: true,
                    },
                ],
                indexes: [],
                triggers: [],
                constraints: [
                    {
                        type: types_1.ConstraintType.PRIMARY_KEY,
                        name: `${ctx.overrideTableName}_pkey`,
                        tableName: ctx.overrideTableName,
                        columnNames: ['name'],
                        synchronize: true,
                    },
                ],
                synchronize: true,
            });
        }
        return ctx.build();
    }
    finally {
        if (options.reset) {
            (0, register_1.resetRegisteredItems)();
        }
    }
};
exports.schemaFromCode = schemaFromCode;
//# sourceMappingURL=schema-from-code.js.map