import { AssetFile, Exif } from 'src/database';
import { BulkIdResponseDto } from 'src/dtos/asset-ids.response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { ExifResponseDto } from 'src/dtos/exif.dto';
import { AssetFileType, AssetType, AssetVisibility, Permission } from 'src/enum';
import { AuthRequest } from 'src/middleware/auth.guard';
import { AccessRepository } from 'src/repositories/access.repository';
import { AssetRepository } from 'src/repositories/asset.repository';
import { EventRepository } from 'src/repositories/event.repository';
import { PartnerRepository } from 'src/repositories/partner.repository';
import { IBulkAsset, ImmichFile, UploadFile, UploadRequest } from 'src/types';
export declare const getAssetFile: (files: AssetFile[], type: AssetFileType, { isEdited }: {
    isEdited: boolean;
}) => AssetFile | undefined;
export declare const getAssetFiles: (files: AssetFile[]) => {
    fullsizeFile: AssetFile | undefined;
    previewFile: AssetFile | undefined;
    thumbnailFile: AssetFile | undefined;
    sidecarFile: AssetFile | undefined;
    editedFullsizeFile: AssetFile | undefined;
    editedPreviewFile: AssetFile | undefined;
    editedThumbnailFile: AssetFile | undefined;
};
export declare const addAssets: (auth: AuthDto, repositories: {
    access: AccessRepository;
    bulk: IBulkAsset;
}, dto: {
    parentId: string;
    assetIds: string[];
}) => Promise<BulkIdResponseDto[]>;
export declare const removeAssets: (auth: AuthDto, repositories: {
    access: AccessRepository;
    bulk: IBulkAsset;
}, dto: {
    parentId: string;
    assetIds: string[];
    canAlwaysRemove: Permission;
}) => Promise<BulkIdResponseDto[]>;
export type PartnerIdOptions = {
    userId: string;
    repository: PartnerRepository;
    timelineEnabled?: boolean;
};
export declare const getMyPartnerIds: ({ userId, repository, timelineEnabled }: PartnerIdOptions) => Promise<string[]>;
export type AssetHookRepositories = {
    asset: AssetRepository;
    event: EventRepository;
};
export declare const onBeforeLink: ({ asset: assetRepository, event: eventRepository }: AssetHookRepositories, { userId, livePhotoVideoId }: {
    userId: string;
    livePhotoVideoId: string;
}) => Promise<void>;
export declare const onBeforeUnlink: ({ asset: assetRepository }: AssetHookRepositories, { livePhotoVideoId }: {
    livePhotoVideoId: string;
}) => Promise<{
    id: string;
    type: AssetType;
    updatedAt: Date;
    createdAt: Date;
    deletedAt: Date | null;
    status: import("src/enum").AssetStatus;
    updateId: string;
    ownerId: string;
    width: number | null;
    height: number | null;
    deviceAssetId: string;
    deviceId: string;
    originalPath: string;
    fileCreatedAt: Date;
    fileModifiedAt: Date;
    isFavorite: boolean;
    duration: string | null;
    encodedVideoPath: string | null;
    checksum: Buffer<ArrayBufferLike>;
    livePhotoVideoId: string | null;
    originalFileName: string;
    thumbhash: Buffer<ArrayBufferLike> | null;
    isOffline: boolean;
    libraryId: string | null;
    isExternal: boolean;
    localDateTime: Date;
    stackId: string | null;
    duplicateId: string | null;
    visibility: AssetVisibility;
    isEdited: boolean;
    exifInfo?: Exif | null | undefined;
    faces?: {
        id: string;
        assetId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        updateId: string;
        personId: string | null;
        imageWidth: number;
        imageHeight: number;
        boundingBoxX1: number;
        boundingBoxY1: number;
        boundingBoxX2: number;
        boundingBoxY2: number;
        sourceType: import("src/enum").SourceType;
        isVisible: boolean;
    }[] | undefined;
    library?: {
        name: string;
        id: string;
        updatedAt: Date;
        createdAt: Date;
        deletedAt: Date | null;
        updateId: string;
        ownerId: string;
        importPaths: string[];
        exclusionPatterns: string[];
        refreshedAt: Date | null;
    } | null | undefined;
    owner?: {
        name: string;
        id: string;
        email: string;
        profileImagePath: string;
        avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<import("../schema").DB, "asset" | "user", "avatarColor">;
        profileChangedAt: Date;
    } | null | undefined;
    smartSearch?: {
        assetId: string;
        embedding: string;
    } | null | undefined;
    stack?: import("src/database").Stack | null | undefined;
    files?: {
        id: string;
        type: AssetFileType;
        path: string;
        isEdited: boolean;
    }[] | undefined;
    tags?: {
        id: string;
        value: string;
        createdAt: Date;
        updatedAt: Date;
        color: string | null;
        parentId: string | null;
    }[] | undefined;
    edits?: import("../dtos/editing.dto").AssetEditActionItem[] | undefined;
} | null>;
export declare const onAfterUnlink: ({ asset: assetRepository, event: eventRepository }: AssetHookRepositories, { userId, livePhotoVideoId, visibility }: {
    userId: string;
    livePhotoVideoId: string;
    visibility: AssetVisibility;
}) => Promise<void>;
export declare function mapToUploadFile(file: ImmichFile): UploadFile;
export declare const asUploadRequest: (request: AuthRequest, file: Express.Multer.File) => UploadRequest;
export declare const getDimensions: (exifInfo: ExifResponseDto | Exif) => {
    width: number;
    height: number;
};
export declare const isPanorama: (asset: {
    exifInfo?: Exif | null;
    originalFileName: string;
}) => boolean;
