import { SyncItem } from 'src/dtos/sync.dto';
import { SyncEntityType } from 'src/enum';
import { SyncAck } from 'src/types';
type Impossible<K extends keyof any> = {
    [P in K]: never;
};
type Exact<T, U extends T = T> = U & Impossible<Exclude<keyof U, keyof T>>;
export declare const fromAck: (ack: string) => SyncAck;
export declare const toAck: ({ type, updateId, extraId }: SyncAck) => string;
export declare const mapJsonLine: (object: unknown) => string;
export type SerializeOptions<T extends keyof SyncItem, D extends SyncItem[T]> = {
    type: T;
    data: Exact<SyncItem[T], D>;
    ids: [string] | [string, string];
    ackType?: SyncEntityType;
};
export declare const serialize: <T extends keyof SyncItem, D extends SyncItem[T]>({ type, data, ids, ackType, }: SerializeOptions<T, D>) => string;
export {};
