"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DayMs = exports.HourMs = exports.MinuteMs = exports.SecondMs = void 0;
exports.validDateTime = validDateTime;
exports.isDateOrTime = isDateOrTime;
exports.dateTimeToExif = dateTimeToExif;
exports.toExifString = toExifString;
exports.hms = hms;
const luxon_1 = require("luxon");
const ExifDate_1 = require("./ExifDate");
const ExifDateTime_1 = require("./ExifDateTime");
const ExifTime_1 = require("./ExifTime");
function validDateTime(dt) {
    return dt?.isValid === true;
}
exports.SecondMs = 1000;
exports.MinuteMs = 60 * exports.SecondMs;
exports.HourMs = 60 * exports.MinuteMs;
exports.DayMs = 24 * exports.HourMs;
function isDateOrTime(o) {
    return (o instanceof ExifDateTime_1.ExifDateTime ||
        o instanceof ExifDate_1.ExifDate ||
        o instanceof ExifTime_1.ExifTime ||
        luxon_1.DateTime.isDateTime(o));
}
function dateTimeToExif(d, opts) {
    return d.toFormat("y:MM:dd HH:mm:ss" +
        (opts?.includeMilliseconds === true ? ".u" : "") +
        (opts?.includeOffset === false ? "" : "ZZ"));
}
function toExifString(d) {
    if (luxon_1.DateTime.isDateTime(d)) {
        return dateTimeToExif(d);
    }
    else {
        return d?.toExifString?.();
    }
}
function hms(d, opts) {
    return d.toFormat("HH:mm:ss" + (opts?.includeMilliseconds === true ? ".SSS" : ""));
}
//# sourceMappingURL=DateTime.js.map