import { FactoryProvider, ValueProvider } from '@nestjs/common';
import { ClsModuleProxyProviderOptions, ClsProxyFactoryReturnType } from './proxy-provider.interfaces';
type ProxyOptions = {
    type?: ClsProxyFactoryReturnType;
    strict?: boolean;
};
export declare class ProxyProviderManager {
    private static clsService;
    private static proxyProviderMap;
    private static proxyProviderResolver?;
    /**
     * Reset method called by the ClsModule#forRoot/Async before the init method is called.
     *
     * It ensures that the internal state is reset to support testing multiple setups in the same process.
     *
     * Otherwise the proxy provider map would leak from one test to the next.
     *
     * FUTURE:
     * A better approach would be to store the proxy provider map in a local instance, instead of a global static variable.
     */
    static reset(): void;
    /**
     * Init method called by the ClsRootModule#onModuleInit after it is certain
     * that all Proxy Providers have been registered.
     */
    static init(): void;
    static createProxyProvider(options: ClsModuleProxyProviderOptions): FactoryProvider<any>;
    static createProxyProviderFromExistingKey(providerKey: symbol | string, options?: ProxyOptions): ValueProvider<any>;
    private static getInjectableProxyMetadata;
    private static getProxyProviderToken;
    private static createProxy;
    static resolveProxyProviders(providerSymbols?: symbol[]): Promise<void>;
}
export {};
//# sourceMappingURL=proxy-provider-manager.d.ts.map