/**
 * Tranformation matrix that mirrors on x-axis
 * @returns {Matrix} Affine Matrix
 */
export function flipX () {
  return {
    a: 1,
    c: 0,
    e: 0,
    b: 0,
    d: -1,
    f: 0
  }
}

/**
 * Tranformation matrix that mirrors on y-axis
 * @returns {Matrix} Affine Matrix
 */
export function flipY () {
  return {
    a: -1,
    c: 0,
    e: 0,
    b: 0,
    d: 1,
    f: 0
  }
}

/**
 * Tranformation matrix that mirrors on origin
 * @returns {Matrix} Affine Matrix
 */
export function flipOrigin () {
  return {
    a: -1,
    c: 0,
    e: 0,
    b: 0,
    d: -1,
    f: 0
  }
}
