"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueueController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const decorators_1 = require("../decorators");
const auth_dto_1 = require("../dtos/auth.dto");
const queue_dto_1 = require("../dtos/queue.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const queue_service_1 = require("../services/queue.service");
let QueueController = class QueueController {
    service;
    constructor(service) {
        this.service = service;
    }
    getQueues(auth) {
        return this.service.getAll(auth);
    }
    getQueue(auth, { name }) {
        return this.service.get(auth, name);
    }
    updateQueue(auth, { name }, dto) {
        return this.service.update(auth, name, dto);
    }
    getQueueJobs(auth, { name }, dto) {
        return this.service.searchJobs(auth, name, dto);
    }
    emptyQueue(auth, { name }, dto) {
        return this.service.emptyQueue(auth, name, dto);
    }
};
exports.QueueController = QueueController;
__decorate([
    (0, common_1.Get)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.QueueRead, admin: true }),
    (0, decorators_1.Endpoint)({
        summary: 'List all queues',
        description: 'Retrieves a list of queues.',
        history: new decorators_1.HistoryBuilder().added('v2.4.0').alpha('v2.4.0'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/queue.dto").QueueResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], QueueController.prototype, "getQueues", null);
__decorate([
    (0, common_1.Get)(':name'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.QueueRead, admin: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve a queue',
        description: 'Retrieves a specific queue by its name.',
        history: new decorators_1.HistoryBuilder().added('v2.4.0').alpha('v2.4.0'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/queue.dto").QueueResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, queue_dto_1.QueueNameParamDto]),
    __metadata("design:returntype", Promise)
], QueueController.prototype, "getQueue", null);
__decorate([
    (0, common_1.Put)(':name'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.QueueUpdate, admin: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Update a queue',
        description: 'Change the paused status of a specific queue.',
        history: new decorators_1.HistoryBuilder().added('v2.4.0').alpha('v2.4.0'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/queue.dto").QueueResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        queue_dto_1.QueueNameParamDto,
        queue_dto_1.QueueUpdateDto]),
    __metadata("design:returntype", Promise)
], QueueController.prototype, "updateQueue", null);
__decorate([
    (0, common_1.Get)(':name/jobs'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.QueueJobRead, admin: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve queue jobs',
        description: 'Retrieves a list of queue jobs from the specified queue.',
        history: new decorators_1.HistoryBuilder().added('v2.4.0').alpha('v2.4.0'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/queue.dto").QueueJobResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        queue_dto_1.QueueNameParamDto,
        queue_dto_1.QueueJobSearchDto]),
    __metadata("design:returntype", Promise)
], QueueController.prototype, "getQueueJobs", null);
__decorate([
    (0, common_1.Delete)(':name/jobs'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.QueueJobDelete, admin: true }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    (0, decorators_1.Endpoint)({
        summary: 'Empty a queue',
        description: 'Removes all jobs from the specified queue.',
        history: new decorators_1.HistoryBuilder().added('v2.4.0').alpha('v2.4.0'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, queue_dto_1.QueueNameParamDto, queue_dto_1.QueueDeleteDto]),
    __metadata("design:returntype", Promise)
], QueueController.prototype, "emptyQueue", null);
exports.QueueController = QueueController = __decorate([
    (0, swagger_1.ApiTags)(enum_1.ApiTag.Queues),
    (0, common_1.Controller)('queues'),
    __metadata("design:paramtypes", [queue_service_1.QueueService])
], QueueController);
//# sourceMappingURL=queue.controller.js.map