import { Request, Response } from 'express';
import { AssetIdsResponseDto } from 'src/dtos/asset-ids.response.dto';
import { AssetIdsDto } from 'src/dtos/asset.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { SharedLinkCreateDto, SharedLinkEditDto, SharedLinkPasswordDto, SharedLinkResponseDto, SharedLinkSearchDto } from 'src/dtos/shared-link.dto';
import { LoginDetails } from 'src/services/auth.service';
import { SharedLinkService } from 'src/services/shared-link.service';
import { UUIDParamDto } from 'src/validation';
export declare class SharedLinkController {
    private service;
    constructor(service: SharedLinkService);
    getAllSharedLinks(auth: AuthDto, dto: SharedLinkSearchDto): Promise<SharedLinkResponseDto[]>;
    getMySharedLink(auth: AuthDto, dto: SharedLinkPasswordDto, request: Request, res: Response, loginDetails: LoginDetails): Promise<SharedLinkResponseDto>;
    getSharedLinkById(auth: AuthDto, { id }: UUIDParamDto): Promise<SharedLinkResponseDto>;
    createSharedLink(auth: AuthDto, dto: SharedLinkCreateDto): Promise<SharedLinkResponseDto>;
    updateSharedLink(auth: AuthDto, { id }: UUIDParamDto, dto: SharedLinkEditDto): Promise<SharedLinkResponseDto>;
    removeSharedLink(auth: AuthDto, { id }: UUIDParamDto): Promise<void>;
    addSharedLinkAssets(auth: AuthDto, { id }: UUIDParamDto, dto: AssetIdsDto): Promise<AssetIdsResponseDto[]>;
    removeSharedLinkAssets(auth: AuthDto, { id }: UUIDParamDto, dto: AssetIdsDto): Promise<AssetIdsResponseDto[]>;
}
