"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserAdminController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const decorators_1 = require("../decorators");
const asset_dto_1 = require("../dtos/asset.dto");
const auth_dto_1 = require("../dtos/auth.dto");
const user_preferences_dto_1 = require("../dtos/user-preferences.dto");
const user_dto_1 = require("../dtos/user.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const user_admin_service_1 = require("../services/user-admin.service");
const validation_1 = require("../validation");
let UserAdminController = class UserAdminController {
    service;
    constructor(service) {
        this.service = service;
    }
    searchUsersAdmin(auth, dto) {
        return this.service.search(auth, dto);
    }
    createUserAdmin(createUserDto) {
        return this.service.create(createUserDto);
    }
    getUserAdmin(auth, { id }) {
        return this.service.get(auth, id);
    }
    updateUserAdmin(auth, { id }, dto) {
        return this.service.update(auth, id, dto);
    }
    deleteUserAdmin(auth, { id }, dto) {
        return this.service.delete(auth, id, dto);
    }
    getUserSessionsAdmin(auth, { id }) {
        return this.service.getSessions(auth, id);
    }
    getUserStatisticsAdmin(auth, { id }, dto) {
        return this.service.getStatistics(auth, id, dto);
    }
    getUserPreferencesAdmin(auth, { id }) {
        return this.service.getPreferences(auth, id);
    }
    updateUserPreferencesAdmin(auth, { id }, dto) {
        return this.service.updatePreferences(auth, id, dto);
    }
    restoreUserAdmin(auth, { id }) {
        return this.service.restore(auth, id);
    }
};
exports.UserAdminController = UserAdminController;
__decorate([
    (0, common_1.Get)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AdminUserRead, admin: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Search users',
        description: 'Search for users.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/user.dto").UserAdminResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, user_dto_1.UserAdminSearchDto]),
    __metadata("design:returntype", Promise)
], UserAdminController.prototype, "searchUsersAdmin", null);
__decorate([
    (0, common_1.Post)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AdminUserCreate, admin: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Create a user',
        description: 'Create a new user.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 201, type: require("../dtos/user.dto").UserAdminResponseDto }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [user_dto_1.UserAdminCreateDto]),
    __metadata("design:returntype", Promise)
], UserAdminController.prototype, "createUserAdmin", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AdminUserRead, admin: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve a user',
        description: 'Retrieve  a specific user by their ID.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/user.dto").UserAdminResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], UserAdminController.prototype, "getUserAdmin", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AdminUserUpdate, admin: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Update a user',
        description: 'Update an existing user.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/user.dto").UserAdminResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        user_dto_1.UserAdminUpdateDto]),
    __metadata("design:returntype", Promise)
], UserAdminController.prototype, "updateUserAdmin", null);
__decorate([
    (0, common_1.Delete)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AdminUserDelete, admin: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Delete a user',
        description: 'Delete a user.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/user.dto").UserAdminResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        user_dto_1.UserAdminDeleteDto]),
    __metadata("design:returntype", Promise)
], UserAdminController.prototype, "deleteUserAdmin", null);
__decorate([
    (0, common_1.Get)(':id/sessions'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AdminSessionRead, admin: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve user sessions',
        description: 'Retrieve all sessions for a specific user.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/session.dto").SessionResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], UserAdminController.prototype, "getUserSessionsAdmin", null);
__decorate([
    (0, common_1.Get)(':id/statistics'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AdminUserRead, admin: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve user statistics',
        description: 'Retrieve asset statistics for a specific user.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/asset.dto").AssetStatsResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        asset_dto_1.AssetStatsDto]),
    __metadata("design:returntype", Promise)
], UserAdminController.prototype, "getUserStatisticsAdmin", null);
__decorate([
    (0, common_1.Get)(':id/preferences'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AdminUserRead, admin: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve user preferences',
        description: 'Retrieve the preferences of a specific user.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/user-preferences.dto").UserPreferencesResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], UserAdminController.prototype, "getUserPreferencesAdmin", null);
__decorate([
    (0, common_1.Put)(':id/preferences'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AdminUserUpdate, admin: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Update user preferences',
        description: 'Update the preferences of a specific user.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/user-preferences.dto").UserPreferencesResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        user_preferences_dto_1.UserPreferencesUpdateDto]),
    __metadata("design:returntype", Promise)
], UserAdminController.prototype, "updateUserPreferencesAdmin", null);
__decorate([
    (0, common_1.Post)(':id/restore'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AdminUserDelete, admin: true }),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, decorators_1.Endpoint)({
        summary: 'Restore a deleted user',
        description: 'Restore a previously deleted user.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: require("../dtos/user.dto").UserAdminResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], UserAdminController.prototype, "restoreUserAdmin", null);
exports.UserAdminController = UserAdminController = __decorate([
    (0, swagger_1.ApiTags)(enum_1.ApiTag.UsersAdmin),
    (0, common_1.Controller)('admin/users'),
    __metadata("design:paramtypes", [user_admin_service_1.UserAdminService])
], UserAdminController);
//# sourceMappingURL=user-admin.controller.js.map