"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkflowController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const decorators_1 = require("../decorators");
const auth_dto_1 = require("../dtos/auth.dto");
const workflow_dto_1 = require("../dtos/workflow.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const workflow_service_1 = require("../services/workflow.service");
const validation_1 = require("../validation");
let WorkflowController = class WorkflowController {
    service;
    constructor(service) {
        this.service = service;
    }
    createWorkflow(auth, dto) {
        return this.service.create(auth, dto);
    }
    getWorkflows(auth) {
        return this.service.getAll(auth);
    }
    getWorkflow(auth, { id }) {
        return this.service.get(auth, id);
    }
    updateWorkflow(auth, { id }, dto) {
        return this.service.update(auth, id, dto);
    }
    deleteWorkflow(auth, { id }) {
        return this.service.delete(auth, id);
    }
};
exports.WorkflowController = WorkflowController;
__decorate([
    (0, common_1.Post)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.WorkflowCreate }),
    (0, decorators_1.Endpoint)({
        summary: 'Create a workflow',
        description: 'Create a new workflow, the workflow can also be created with empty filters and actions.',
        history: new decorators_1.HistoryBuilder().added('v2.3.0').alpha('v2.3.0'),
    }),
    openapi.ApiResponse({ status: 201, type: require("../dtos/workflow.dto").WorkflowResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, workflow_dto_1.WorkflowCreateDto]),
    __metadata("design:returntype", Promise)
], WorkflowController.prototype, "createWorkflow", null);
__decorate([
    (0, common_1.Get)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.WorkflowRead }),
    (0, decorators_1.Endpoint)({
        summary: 'List all workflows',
        description: 'Retrieve a list of workflows available to the authenticated user.',
        history: new decorators_1.HistoryBuilder().added('v2.3.0').alpha('v2.3.0'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/workflow.dto").WorkflowResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], WorkflowController.prototype, "getWorkflows", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.WorkflowRead }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve a workflow',
        description: 'Retrieve information about a specific workflow by its ID.',
        history: new decorators_1.HistoryBuilder().added('v2.3.0').alpha('v2.3.0'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/workflow.dto").WorkflowResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], WorkflowController.prototype, "getWorkflow", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.WorkflowUpdate }),
    (0, decorators_1.Endpoint)({
        summary: 'Update a workflow',
        description: 'Update the information of a specific workflow by its ID. This endpoint can be used to update the workflow name, description, trigger type, filters and actions order, etc.',
        history: new decorators_1.HistoryBuilder().added('v2.3.0').alpha('v2.3.0'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/workflow.dto").WorkflowResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        workflow_dto_1.WorkflowUpdateDto]),
    __metadata("design:returntype", Promise)
], WorkflowController.prototype, "updateWorkflow", null);
__decorate([
    (0, common_1.Delete)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.WorkflowDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    (0, decorators_1.Endpoint)({
        summary: 'Delete a workflow',
        description: 'Delete a workflow by its ID.',
        history: new decorators_1.HistoryBuilder().added('v2.3.0').alpha('v2.3.0'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], WorkflowController.prototype, "deleteWorkflow", null);
exports.WorkflowController = WorkflowController = __decorate([
    (0, swagger_1.ApiTags)('Workflows'),
    (0, common_1.Controller)('workflows'),
    __metadata("design:paramtypes", [workflow_service_1.WorkflowService])
], WorkflowController);
//# sourceMappingURL=workflow.controller.js.map