"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MaintenanceDetectInstallResponseDto = exports.MaintenanceDetectInstallStorageFolderDto = exports.MaintenanceStatusResponseDto = exports.MaintenanceAuthDto = exports.MaintenanceLoginDto = exports.SetMaintenanceModeDto = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const enum_1 = require("../enum");
const validation_1 = require("../validation");
class SetMaintenanceModeDto {
    action;
    restoreBackupFilename;
    static _OPENAPI_METADATA_FACTORY() {
        return { action: { required: true, enum: require("../enum").MaintenanceAction }, restoreBackupFilename: { required: false, type: () => String } };
    }
}
exports.SetMaintenanceModeDto = SetMaintenanceModeDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.MaintenanceAction, name: 'MaintenanceAction', description: 'Maintenance action' }),
    __metadata("design:type", String)
], SetMaintenanceModeDto.prototype, "action", void 0);
__decorate([
    (0, class_validator_1.ValidateIf)((o) => o.action === enum_1.MaintenanceAction.RestoreDatabase),
    (0, validation_1.ValidateString)({ description: 'Restore backup filename' }),
    __metadata("design:type", String)
], SetMaintenanceModeDto.prototype, "restoreBackupFilename", void 0);
class MaintenanceLoginDto {
    token;
    static _OPENAPI_METADATA_FACTORY() {
        return { token: { required: false, type: () => String } };
    }
}
exports.MaintenanceLoginDto = MaintenanceLoginDto;
__decorate([
    (0, validation_1.ValidateString)({ optional: true, description: 'Maintenance token' }),
    __metadata("design:type", String)
], MaintenanceLoginDto.prototype, "token", void 0);
class MaintenanceAuthDto {
    username;
    static _OPENAPI_METADATA_FACTORY() {
        return { username: { required: true, type: () => String } };
    }
}
exports.MaintenanceAuthDto = MaintenanceAuthDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Maintenance username' }),
    __metadata("design:type", String)
], MaintenanceAuthDto.prototype, "username", void 0);
class MaintenanceStatusResponseDto {
    active;
    action;
    progress;
    task;
    error;
    static _OPENAPI_METADATA_FACTORY() {
        return { active: { required: true, type: () => Boolean }, action: { required: true, enum: require("../enum").MaintenanceAction }, progress: { required: false, type: () => Number }, task: { required: false, type: () => String }, error: { required: false, type: () => String } };
    }
}
exports.MaintenanceStatusResponseDto = MaintenanceStatusResponseDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.MaintenanceAction, name: 'MaintenanceAction', description: 'Maintenance action' }),
    __metadata("design:type", String)
], MaintenanceStatusResponseDto.prototype, "action", void 0);
class MaintenanceDetectInstallStorageFolderDto {
    folder;
    readable;
    writable;
    files;
    static _OPENAPI_METADATA_FACTORY() {
        return { folder: { required: true, enum: require("../enum").StorageFolder }, readable: { required: true, type: () => Boolean }, writable: { required: true, type: () => Boolean }, files: { required: true, type: () => Number } };
    }
}
exports.MaintenanceDetectInstallStorageFolderDto = MaintenanceDetectInstallStorageFolderDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.StorageFolder, name: 'StorageFolder', description: 'Storage folder' }),
    __metadata("design:type", String)
], MaintenanceDetectInstallStorageFolderDto.prototype, "folder", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Whether the folder is readable' }),
    __metadata("design:type", Boolean)
], MaintenanceDetectInstallStorageFolderDto.prototype, "readable", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ description: 'Whether the folder is writable' }),
    __metadata("design:type", Boolean)
], MaintenanceDetectInstallStorageFolderDto.prototype, "writable", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Number of files in the folder' }),
    __metadata("design:type", Number)
], MaintenanceDetectInstallStorageFolderDto.prototype, "files", void 0);
class MaintenanceDetectInstallResponseDto {
    storage;
    static _OPENAPI_METADATA_FACTORY() {
        return { storage: { required: true, type: () => [require("./maintenance.dto").MaintenanceDetectInstallStorageFolderDto] } };
    }
}
exports.MaintenanceDetectInstallResponseDto = MaintenanceDetectInstallResponseDto;
//# sourceMappingURL=maintenance.dto.js.map