import { PluginAction, PluginFilter } from 'src/database';
import { PluginContext as PluginContextType, PluginTriggerType } from 'src/enum';
import type { JSONSchema } from 'src/types/plugin-schema.types';
export declare class PluginTriggerResponseDto {
    type: PluginTriggerType;
    contextType: PluginContextType;
}
export declare class PluginResponseDto {
    id: string;
    name: string;
    title: string;
    description: string;
    author: string;
    version: string;
    createdAt: string;
    updatedAt: string;
    filters: PluginFilterResponseDto[];
    actions: PluginActionResponseDto[];
}
export declare class PluginFilterResponseDto {
    id: string;
    pluginId: string;
    methodName: string;
    title: string;
    description: string;
    supportedContexts: PluginContextType[];
    schema: JSONSchema | null;
}
export declare class PluginActionResponseDto {
    id: string;
    pluginId: string;
    methodName: string;
    title: string;
    description: string;
    supportedContexts: PluginContextType[];
    schema: JSONSchema | null;
}
export declare class PluginInstallDto {
    manifestPath: string;
}
export type MapPlugin = {
    id: string;
    name: string;
    title: string;
    description: string;
    author: string;
    version: string;
    wasmPath: string;
    createdAt: Date;
    updatedAt: Date;
    filters: PluginFilter[];
    actions: PluginAction[];
};
export declare function mapPlugin(plugin: MapPlugin): PluginResponseDto;
