"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PluginInstallDto = exports.PluginActionResponseDto = exports.PluginFilterResponseDto = exports.PluginResponseDto = exports.PluginTriggerResponseDto = void 0;
exports.mapPlugin = mapPlugin;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const enum_1 = require("../enum");
const validation_1 = require("../validation");
class PluginTriggerResponseDto {
    type;
    contextType;
    static _OPENAPI_METADATA_FACTORY() {
        return { type: { required: true, enum: require("../enum").PluginTriggerType }, contextType: { required: true, enum: require("../enum").PluginContext } };
    }
}
exports.PluginTriggerResponseDto = PluginTriggerResponseDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.PluginTriggerType, name: 'PluginTriggerType', description: 'Trigger type' }),
    __metadata("design:type", String)
], PluginTriggerResponseDto.prototype, "type", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.PluginContext, name: 'PluginContextType', description: 'Context type' }),
    __metadata("design:type", String)
], PluginTriggerResponseDto.prototype, "contextType", void 0);
class PluginResponseDto {
    id;
    name;
    title;
    description;
    author;
    version;
    createdAt;
    updatedAt;
    filters;
    actions;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, name: { required: true, type: () => String }, title: { required: true, type: () => String }, description: { required: true, type: () => String }, author: { required: true, type: () => String }, version: { required: true, type: () => String }, createdAt: { required: true, type: () => String }, updatedAt: { required: true, type: () => String }, filters: { required: true, type: () => [require("./plugin.dto").PluginFilterResponseDto] }, actions: { required: true, type: () => [require("./plugin.dto").PluginActionResponseDto] } };
    }
}
exports.PluginResponseDto = PluginResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Plugin ID' }),
    __metadata("design:type", String)
], PluginResponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Plugin name' }),
    __metadata("design:type", String)
], PluginResponseDto.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Plugin title' }),
    __metadata("design:type", String)
], PluginResponseDto.prototype, "title", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Plugin description' }),
    __metadata("design:type", String)
], PluginResponseDto.prototype, "description", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Plugin author' }),
    __metadata("design:type", String)
], PluginResponseDto.prototype, "author", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Plugin version' }),
    __metadata("design:type", String)
], PluginResponseDto.prototype, "version", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Creation date' }),
    __metadata("design:type", String)
], PluginResponseDto.prototype, "createdAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Last update date' }),
    __metadata("design:type", String)
], PluginResponseDto.prototype, "updatedAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Plugin filters' }),
    __metadata("design:type", Array)
], PluginResponseDto.prototype, "filters", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Plugin actions' }),
    __metadata("design:type", Array)
], PluginResponseDto.prototype, "actions", void 0);
class PluginFilterResponseDto {
    id;
    pluginId;
    methodName;
    title;
    description;
    supportedContexts;
    schema;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, pluginId: { required: true, type: () => String }, methodName: { required: true, type: () => String }, title: { required: true, type: () => String }, description: { required: true, type: () => String }, supportedContexts: { required: true, enum: require("../enum").PluginContext, isArray: true }, schema: { required: true, type: () => Object, nullable: true } };
    }
}
exports.PluginFilterResponseDto = PluginFilterResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Filter ID' }),
    __metadata("design:type", String)
], PluginFilterResponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Plugin ID' }),
    __metadata("design:type", String)
], PluginFilterResponseDto.prototype, "pluginId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Method name' }),
    __metadata("design:type", String)
], PluginFilterResponseDto.prototype, "methodName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Filter title' }),
    __metadata("design:type", String)
], PluginFilterResponseDto.prototype, "title", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Filter description' }),
    __metadata("design:type", String)
], PluginFilterResponseDto.prototype, "description", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.PluginContext, name: 'PluginContextType', each: true, description: 'Supported contexts' }),
    __metadata("design:type", Array)
], PluginFilterResponseDto.prototype, "supportedContexts", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Filter schema' }),
    __metadata("design:type", Object)
], PluginFilterResponseDto.prototype, "schema", void 0);
class PluginActionResponseDto {
    id;
    pluginId;
    methodName;
    title;
    description;
    supportedContexts;
    schema;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, pluginId: { required: true, type: () => String }, methodName: { required: true, type: () => String }, title: { required: true, type: () => String }, description: { required: true, type: () => String }, supportedContexts: { required: true, enum: require("../enum").PluginContext, isArray: true }, schema: { required: true, type: () => Object, nullable: true } };
    }
}
exports.PluginActionResponseDto = PluginActionResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Action ID' }),
    __metadata("design:type", String)
], PluginActionResponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Plugin ID' }),
    __metadata("design:type", String)
], PluginActionResponseDto.prototype, "pluginId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Method name' }),
    __metadata("design:type", String)
], PluginActionResponseDto.prototype, "methodName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Action title' }),
    __metadata("design:type", String)
], PluginActionResponseDto.prototype, "title", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Action description' }),
    __metadata("design:type", String)
], PluginActionResponseDto.prototype, "description", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.PluginContext, name: 'PluginContextType', each: true, description: 'Supported contexts' }),
    __metadata("design:type", Array)
], PluginActionResponseDto.prototype, "supportedContexts", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Action schema' }),
    __metadata("design:type", Object)
], PluginActionResponseDto.prototype, "schema", void 0);
class PluginInstallDto {
    manifestPath;
    static _OPENAPI_METADATA_FACTORY() {
        return { manifestPath: { required: true, type: () => String } };
    }
}
exports.PluginInstallDto = PluginInstallDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Path to plugin manifest file' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], PluginInstallDto.prototype, "manifestPath", void 0);
function mapPlugin(plugin) {
    return {
        id: plugin.id,
        name: plugin.name,
        title: plugin.title,
        description: plugin.description,
        author: plugin.author,
        version: plugin.version,
        createdAt: plugin.createdAt.toISOString(),
        updatedAt: plugin.updatedAt.toISOString(),
        filters: plugin.filters,
        actions: plugin.actions,
    };
}
//# sourceMappingURL=plugin.dto.js.map