"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.FutoLayout = void 0;
const components_1 = require("@react-email/components");
const React = __importStar(require("react"));
const footer_template_1 = require("./footer.template");
const FutoLayout = ({ children, preview }) => (React.createElement(components_1.Html, null,
    React.createElement(components_1.Tailwind, { config: {
            presets: [require('tailwindcss-preset-email')],
            theme: {
                extend: {
                    colors: {
                        'immich-primary': '#4250AF',
                        'futo-primary': '#000000',
                        'futo-bg': '#F4F4f4',
                        'futo-gray': '#F6F6F4',
                        'futo-footer': '#6A737D',
                    },
                    fontFamily: {
                        sans: ['Overpass', 'sans-serif'],
                        mono: ['Overpass Mono', 'monospace'],
                    },
                },
            },
        } },
        React.createElement(components_1.Head, null,
            React.createElement(components_1.Font, { fontFamily: "Overpass", fallbackFontFamily: "sans-serif", webFont: {
                    url: 'https://fonts.gstatic.com/s/overpass/v13/qFdH35WCmI96Ajtm81GrU9vyww.woff2',
                    format: 'woff2',
                }, fontWeight: '100 900', fontStyle: "normal" })),
        React.createElement(components_1.Preview, null, preview),
        React.createElement(components_1.Body, { className: "bg-futo-bg my-auto mx-auto px-2 font-sans text-base text-futo-primary" },
            React.createElement(components_1.Container, { className: "my-[40px] mx-auto max-w-[465px]" },
                React.createElement(components_1.Section, { className: "my-6 p-12 border border-red-400 rounded-[50px] bg-gray-50" },
                    React.createElement(components_1.Section, { className: "flex justify-center mb-12" },
                        React.createElement(components_1.Img, { src: "https://immich.app/img/immich-logo-inline-light.png", className: "h-12 antialiased rounded-none", alt: "Immich" })),
                    children),
                React.createElement(components_1.Section, { className: "flex justify-center my-6" },
                    React.createElement(components_1.Link, { href: "https://futo.org" },
                        React.createElement(components_1.Img, { className: "h-6", src: "https://futo.org/images/FutoMainLogo.svg", alt: "FUTO" }))),
                React.createElement(components_1.Hr, { className: "my-2 text-futo-gray" }),
                React.createElement(footer_template_1.ImmichFooter, null))))));
exports.FutoLayout = FutoLayout;
exports.FutoLayout.PreviewProps = {
    preview: 'This is the preview shown on some mail clients',
    children: React.createElement(components_1.Text, null, "Email body goes here."),
};
exports.default = exports.FutoLayout;
//# sourceMappingURL=futo.layout.js.map