import { CallHandler, ExecutionContext, NestInterceptor } from '@nestjs/common';
import { Reflector } from '@nestjs/core';
import { Observable } from 'rxjs';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { AssetMediaService } from 'src/services/asset-media.service';
import { UploadFile, UploadFiles } from 'src/types';
export declare function getFile(files: UploadFiles, property: 'assetData' | 'sidecarData'): UploadFile;
export declare function getFiles(files: UploadFiles): {
    file: UploadFile;
    sidecarFile: UploadFile;
};
export declare class FileUploadInterceptor implements NestInterceptor {
    private reflect;
    private assetService;
    private logger;
    private handlers;
    private defaultStorage;
    constructor(reflect: Reflector, assetService: AssetMediaService, logger: LoggingRepository);
    intercept(context: ExecutionContext, next: CallHandler<any>): Promise<Observable<any>>;
    private fileFilter;
    private filename;
    private destination;
    private handleFile;
    private removeFile;
    private isAssetUploadFile;
    private getHandler;
}
