import { Insertable, Kysely, Updateable } from 'kysely';
import { DB } from 'src/schema';
import { ApiKeyTable } from 'src/schema/tables/api-key.table';
export declare class ApiKeyRepository {
    private db;
    constructor(db: Kysely<DB>);
    create(dto: Insertable<ApiKeyTable>): Promise<{
        name: string;
        id: string;
        userId: string;
        updatedAt: Date;
        createdAt: Date;
        permissions: import("../enum").Permission[];
    }>;
    update(userId: string, id: string, dto: Updateable<ApiKeyTable>): Promise<{
        name: string;
        id: string;
        userId: string;
        updatedAt: Date;
        createdAt: Date;
        permissions: import("../enum").Permission[];
    }>;
    delete(userId: string, id: string): Promise<void>;
    getKey(hashedToken: string): Promise<{
        id: string;
        permissions: import("../enum").Permission[];
        user: {
            name: string;
            id: string;
            email: string;
            isAdmin: boolean;
            quotaSizeInBytes: number | null;
            quotaUsageInBytes: number;
        } | null;
    } | undefined>;
    getById(userId: string, id: string): Promise<{
        name: string;
        id: string;
        userId: string;
        updatedAt: Date;
        createdAt: Date;
        permissions: import("../enum").Permission[];
    } | undefined>;
    getByUserId(userId: string): Promise<{
        name: string;
        id: string;
        userId: string;
        updatedAt: Date;
        createdAt: Date;
        permissions: import("../enum").Permission[];
    }[]>;
}
