"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppRepository = void 0;
const common_1 = require("@nestjs/common");
const redis_adapter_1 = require("@socket.io/redis-adapter");
const ioredis_1 = __importDefault(require("ioredis"));
const socket_io_1 = require("socket.io");
const enum_1 = require("../enum");
const config_repository_1 = require("./config.repository");
let AppRepository = class AppRepository {
    closeFn;
    exitApp() {
        void this.closeFn?.().finally(() => process.exit(enum_1.ExitCode.AppRestart));
        setTimeout(() => process.exit(enum_1.ExitCode.AppRestart), 2000);
    }
    setCloseFn(fn) {
        this.closeFn = fn;
    }
    async sendOneShotAppRestart(state) {
        const server = new socket_io_1.Server();
        const { redis } = new config_repository_1.ConfigRepository().getEnv();
        const pubClient = new ioredis_1.default({ ...redis, lazyConnect: true });
        const subClient = pubClient.duplicate();
        await Promise.all([pubClient.connect(), subClient.connect()]);
        server.adapter((0, redis_adapter_1.createAdapter)(pubClient, subClient));
        server.emit('AppRestartV1', state, async () => {
            const responses = await server.serverSideEmitWithAck('AppRestart', state);
            if (responses.some((response) => response !== 'ok')) {
                throw new Error("One or more node(s) returned a non-'ok' response to our restart request!");
            }
            pubClient.disconnect();
            subClient.disconnect();
        });
    }
};
exports.AppRepository = AppRepository;
exports.AppRepository = AppRepository = __decorate([
    (0, common_1.Injectable)()
], AppRepository);
//# sourceMappingURL=app.repository.js.map