import { Writable } from 'node:stream';
import sharp from 'sharp';
import { Exif } from 'src/database';
import { RawExtractedFormat } from 'src/enum';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { DecodeToBufferOptions, GenerateThumbhashOptions, GenerateThumbnailOptions, ImageDimensions, ProbeOptions, TranscodeCommand, VideoInfo } from 'src/types';
export type ExtractResult = {
    buffer: Buffer;
    format: RawExtractedFormat;
};
export declare class MediaRepository {
    private logger;
    constructor(logger: LoggingRepository);
    extract(input: string): Promise<ExtractResult | null>;
    writeExif(tags: Partial<Exif>, output: string): Promise<boolean>;
    copyTagGroup(tagGroup: string, source: string, target: string): Promise<boolean>;
    decodeImage(input: string | Buffer, options: DecodeToBufferOptions): Promise<{
        data: Buffer;
        info: sharp.OutputInfo;
    }>;
    private applyEdits;
    generateThumbnail(input: string | Buffer, options: GenerateThumbnailOptions, output: string): Promise<void>;
    private getImageDecodingPipeline;
    generateThumbhash(input: string | Buffer, options: GenerateThumbhashOptions): Promise<Buffer>;
    probe(input: string, options?: ProbeOptions): Promise<VideoInfo>;
    transcode(input: string, output: string | Writable, options: TranscodeCommand): Promise<void>;
    getImageDimensions(input: string | Buffer): Promise<ImageDimensions>;
    private configureFfmpegCall;
    private parseInt;
    private parseFloat;
}
