"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DownloadService = void 0;
const common_1 = require("@nestjs/common");
const node_path_1 = require("node:path");
const storage_core_1 = require("../cores/storage.core");
const enum_1 = require("../enum");
const base_service_1 = require("./base.service");
const bytes_1 = require("../utils/bytes");
const preferences_1 = require("../utils/preferences");
let DownloadService = class DownloadService extends base_service_1.BaseService {
    async getDownloadInfo(auth, dto) {
        let assets;
        if (dto.assetIds) {
            const assetIds = dto.assetIds;
            await this.requireAccess({ auth, permission: enum_1.Permission.AssetDownload, ids: assetIds });
            assets = this.downloadRepository.downloadAssetIds(assetIds);
        }
        else if (dto.albumId) {
            const albumId = dto.albumId;
            await this.requireAccess({ auth, permission: enum_1.Permission.AlbumDownload, ids: [albumId] });
            assets = this.downloadRepository.downloadAlbumId(albumId);
        }
        else if (dto.userId) {
            const userId = dto.userId;
            await this.requireAccess({ auth, permission: enum_1.Permission.TimelineDownload, ids: [userId] });
            assets = this.downloadRepository.downloadUserId(userId);
        }
        else {
            throw new common_1.BadRequestException('assetIds, albumId, or userId is required');
        }
        const targetSize = dto.archiveSize || bytes_1.HumanReadableSize.GiB * 4;
        const metadata = await this.userRepository.getMetadata(auth.user.id);
        const preferences = (0, preferences_1.getPreferences)(metadata);
        const motionIds = new Set();
        const archives = [];
        let archive = { size: 0, assetIds: [] };
        const addToArchive = ({ id, size }) => {
            archive.assetIds.push(id);
            archive.size += Number(size || 0);
            if (archive.size > targetSize) {
                archives.push(archive);
                archive = { size: 0, assetIds: [] };
            }
        };
        for await (const asset of assets) {
            if (asset.livePhotoVideoId) {
                motionIds.add(asset.livePhotoVideoId);
            }
            addToArchive(asset);
        }
        if (motionIds.size > 0) {
            const motionAssets = this.downloadRepository.downloadMotionAssetIds([...motionIds]);
            for await (const motionAsset of motionAssets) {
                if (storage_core_1.StorageCore.isAndroidMotionPath(motionAsset.originalPath) && !preferences.download.includeEmbeddedVideos) {
                    continue;
                }
                addToArchive(motionAsset);
            }
        }
        if (archive.assetIds.length > 0) {
            archives.push(archive);
        }
        let totalSize = 0;
        for (const archive of archives) {
            totalSize += archive.size;
        }
        return { totalSize, archives };
    }
    async downloadArchive(auth, dto) {
        await this.requireAccess({ auth, permission: enum_1.Permission.AssetDownload, ids: dto.assetIds });
        const zip = this.storageRepository.createZipStream();
        const assets = await this.assetRepository.getByIds(dto.assetIds);
        const assetMap = new Map(assets.map((asset) => [asset.id, asset]));
        const paths = {};
        for (const assetId of dto.assetIds) {
            const asset = assetMap.get(assetId);
            if (!asset) {
                continue;
            }
            const { originalPath, originalFileName } = asset;
            let filename = originalFileName;
            const count = paths[filename] || 0;
            paths[filename] = count + 1;
            if (count !== 0) {
                const parsedFilename = (0, node_path_1.parse)(originalFileName);
                filename = `${parsedFilename.name}+${count}${parsedFilename.ext}`;
            }
            let realpath = originalPath;
            try {
                realpath = await this.storageRepository.realpath(originalPath);
            }
            catch {
                this.logger.warn('Unable to resolve realpath', { originalPath });
            }
            zip.addFile(realpath, filename);
        }
        void zip.finalize();
        return { stream: zip.stream };
    }
};
exports.DownloadService = DownloadService;
exports.DownloadService = DownloadService = __decorate([
    (0, common_1.Injectable)()
], DownloadService);
//# sourceMappingURL=download.service.js.map