"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MaintenanceService = void 0;
const common_1 = require("@nestjs/common");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
const base_service_1 = require("./base.service");
const maintenance_1 = require("../utils/maintenance");
const misc_1 = require("../utils/misc");
let MaintenanceService = class MaintenanceService extends base_service_1.BaseService {
    getMaintenanceMode() {
        return this.systemMetadataRepository
            .get(enum_1.SystemMetadataKey.MaintenanceMode)
            .then((state) => state ?? { isMaintenanceMode: false });
    }
    getMaintenanceStatus() {
        return {
            active: false,
            action: enum_1.MaintenanceAction.End,
        };
    }
    detectPriorInstall() {
        return (0, maintenance_1.detectPriorInstall)(this.storageRepository);
    }
    async startMaintenance(action, username) {
        const secret = (0, maintenance_1.generateMaintenanceSecret)();
        await this.systemMetadataRepository.set(enum_1.SystemMetadataKey.MaintenanceMode, {
            isMaintenanceMode: true,
            secret,
            action,
        });
        await this.eventRepository.emit('AppRestart', { isMaintenanceMode: true });
        return {
            jwt: await (0, maintenance_1.signMaintenanceJwt)(secret, {
                username,
            }),
        };
    }
    async startRestoreFlow() {
        const adminUser = await this.userRepository.getAdmin();
        if (adminUser) {
            throw new common_1.BadRequestException('The server already has an admin');
        }
        return this.startMaintenance({
            action: enum_1.MaintenanceAction.SelectDatabaseRestore,
        }, 'admin');
    }
    onRestart(event, ack) {
        this.logger.log(`Restarting due to event... ${JSON.stringify(event)}`);
        ack?.('ok');
        this.appRepository.exitApp();
    }
    async createLoginUrl(auth, secret) {
        const { server } = await this.getConfig({ withCache: true });
        const baseUrl = (0, misc_1.getExternalDomain)(server);
        if (!secret) {
            const state = await this.getMaintenanceMode();
            if (!state.isMaintenanceMode) {
                throw new Error('Not in maintenance mode');
            }
            secret = state.secret;
        }
        return await (0, maintenance_1.createMaintenanceLoginUrl)(baseUrl, auth, secret);
    }
};
exports.MaintenanceService = MaintenanceService;
__decorate([
    (0, decorators_1.OnEvent)({ name: 'AppRestart', server: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Function]),
    __metadata("design:returntype", void 0)
], MaintenanceService.prototype, "onRestart", null);
exports.MaintenanceService = MaintenanceService = __decorate([
    (0, common_1.Injectable)()
], MaintenanceService);
//# sourceMappingURL=maintenance.service.js.map