import { AuthDto } from 'src/dtos/auth.dto';
import { NotificationDeleteAllDto, NotificationDto, NotificationSearchDto, NotificationUpdateAllDto, NotificationUpdateDto } from 'src/dtos/notification.dto';
import { SystemConfigSmtpDto } from 'src/dtos/system-config.dto';
import { JobName, JobStatus } from 'src/enum';
import { ArgOf } from 'src/repositories/event.repository';
import { BaseService } from 'src/services/base.service';
import { JobOf } from 'src/types';
export declare class NotificationService extends BaseService {
    private static albumUpdateEmailDelayMs;
    search(auth: AuthDto, dto: NotificationSearchDto): Promise<NotificationDto[]>;
    updateAll(auth: AuthDto, dto: NotificationUpdateAllDto): Promise<void>;
    deleteAll(auth: AuthDto, dto: NotificationDeleteAllDto): Promise<void>;
    get(auth: AuthDto, id: string): Promise<NotificationDto>;
    update(auth: AuthDto, id: string, dto: NotificationUpdateDto): Promise<NotificationDto>;
    delete(auth: AuthDto, id: string): Promise<void>;
    onNotificationsCleanup(): Promise<void>;
    onJobError({ job, error }: ArgOf<'JobError'>): Promise<void>;
    onConfigUpdate({ oldConfig, newConfig }: ArgOf<'ConfigUpdate'>): void;
    onAppRestart(state: ArgOf<'AppRestart'>): void;
    onConfigValidate({ oldConfig, newConfig }: ArgOf<'ConfigValidate'>): Promise<void>;
    onAssetHide({ assetId, userId }: ArgOf<'AssetHide'>): void;
    onAssetShow({ assetId }: ArgOf<'AssetShow'>): Promise<void>;
    onAssetTrash({ assetId, userId }: ArgOf<'AssetTrash'>): void;
    onAssetDelete({ assetId, userId }: ArgOf<'AssetDelete'>): void;
    onAssetsTrash({ assetIds, userId }: ArgOf<'AssetTrashAll'>): void;
    onAssetMetadataExtracted({ assetId, userId, source }: ArgOf<'AssetMetadataExtracted'>): Promise<void>;
    onAssetsRestore({ assetIds, userId }: ArgOf<'AssetRestoreAll'>): void;
    onStackCreate({ userId }: ArgOf<'StackCreate'>): void;
    onStackUpdate({ userId }: ArgOf<'StackUpdate'>): void;
    onStackDelete({ userId }: ArgOf<'StackDelete'>): void;
    onStacksDelete({ userId }: ArgOf<'StackDeleteAll'>): void;
    onUserSignup({ notify, id, password: password }: ArgOf<'UserSignup'>): Promise<void>;
    onUserDelete({ id }: ArgOf<'UserDelete'>): void;
    onAlbumUpdate({ id, recipientId }: ArgOf<'AlbumUpdate'>): Promise<void>;
    onAlbumInvite({ id, userId }: ArgOf<'AlbumInvite'>): Promise<void>;
    onSessionDelete({ sessionId }: ArgOf<'SessionDelete'>): void;
    sendTestEmail(id: string, dto: SystemConfigSmtpDto, tempTemplate?: string): Promise<{
        messageId: string;
    }>;
    handleUserSignup({ id, password }: JobOf<JobName.NotifyUserSignup>): Promise<JobStatus.Success | JobStatus.Skipped>;
    handleAlbumInvite({ id, recipientId }: JobOf<JobName.NotifyAlbumInvite>): Promise<JobStatus.Success | JobStatus.Skipped>;
    handleAlbumUpdate({ id, recipientId }: JobOf<JobName.NotifyAlbumUpdate>): Promise<JobStatus.Success | JobStatus.Skipped>;
    handleSendEmail(data: JobOf<JobName.SendMail>): Promise<JobStatus>;
    private getAlbumThumbnailAttachment;
    private sendAlbumLocalNotification;
}
