import { ClassConstructor } from 'class-transformer';
import { AuthDto } from 'src/dtos/auth.dto';
import { QueueResponseLegacyDto, QueuesResponseLegacyDto } from 'src/dtos/queue-legacy.dto';
import { QueueCommandDto, QueueDeleteDto, QueueJobResponseDto, QueueJobSearchDto, QueueResponseDto, QueueUpdateDto } from 'src/dtos/queue.dto';
import { QueueName } from 'src/enum';
import { ArgOf } from 'src/repositories/event.repository';
import { BaseService } from 'src/services/base.service';
export declare class QueueService extends BaseService {
    private services;
    private nightlyJobsLock;
    onConfigInit({ newConfig: config }: ArgOf<'ConfigInit'>): Promise<void>;
    onConfigUpdate({ newConfig: config }: ArgOf<'ConfigUpdate'>): void;
    onBootstrap(): void;
    private updateConcurrency;
    setServices(services: ClassConstructor<unknown>[]): void;
    runCommandLegacy(name: QueueName, dto: QueueCommandDto): Promise<QueueResponseLegacyDto>;
    getAll(_auth: AuthDto): Promise<QueueResponseDto[]>;
    getAllLegacy(auth: AuthDto): Promise<QueuesResponseLegacyDto>;
    get(auth: AuthDto, name: QueueName): Promise<QueueResponseDto>;
    update(auth: AuthDto, name: QueueName, dto: QueueUpdateDto): Promise<QueueResponseDto>;
    searchJobs(auth: AuthDto, name: QueueName, dto: QueueJobSearchDto): Promise<QueueJobResponseDto[]>;
    emptyQueue(auth: AuthDto, name: QueueName, dto: QueueDeleteDto): Promise<void>;
    private getByName;
    private start;
    private isConcurrentQueue;
    handleNightlyJobs(): Promise<void>;
}
