import { BulkIdResponseDto, BulkIdsDto } from 'src/dtos/asset-ids.response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { TagBulkAssetsDto, TagBulkAssetsResponseDto, TagCreateDto, TagResponseDto, TagUpdateDto, TagUpsertDto } from 'src/dtos/tag.dto';
import { JobStatus } from 'src/enum';
import { BaseService } from 'src/services/base.service';
export declare class TagService extends BaseService {
    getAll(auth: AuthDto): Promise<TagResponseDto[]>;
    get(auth: AuthDto, id: string): Promise<TagResponseDto>;
    create(auth: AuthDto, dto: TagCreateDto): Promise<TagResponseDto>;
    update(auth: AuthDto, id: string, dto: TagUpdateDto): Promise<TagResponseDto>;
    upsert(auth: AuthDto, dto: TagUpsertDto): Promise<TagResponseDto[]>;
    remove(auth: AuthDto, id: string): Promise<void>;
    bulkTagAssets(auth: AuthDto, dto: TagBulkAssetsDto): Promise<TagBulkAssetsResponseDto>;
    addAssets(auth: AuthDto, id: string, dto: BulkIdsDto): Promise<BulkIdResponseDto[]>;
    removeAssets(auth: AuthDto, id: string, dto: BulkIdsDto): Promise<BulkIdResponseDto[]>;
    handleTagCleanup(): Promise<JobStatus>;
    private findOrFail;
    private updateTags;
}
