"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compareExtensions = void 0;
const types_1 = require("../types");
exports.compareExtensions = {
    onMissing: (source) => [
        {
            type: 'ExtensionCreate',
            extension: source,
            reason: types_1.Reason.MissingInTarget,
        },
    ],
    onExtra: (target) => [
        {
            type: 'ExtensionDrop',
            extensionName: target.name,
            reason: types_1.Reason.MissingInSource,
        },
    ],
    onCompare: () => {
        return [];
    },
};
//# sourceMappingURL=extension.comparer.js.map