"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hexOrBufferToBase64 = exports.HumanReadableSize = void 0;
exports.asHumanReadable = asHumanReadable;
const KiB = Math.pow(1024, 1);
const MiB = Math.pow(1024, 2);
const GiB = Math.pow(1024, 3);
const TiB = Math.pow(1024, 4);
const PiB = Math.pow(1024, 5);
exports.HumanReadableSize = { KiB, MiB, GiB, TiB, PiB };
function asHumanReadable(bytes, precision = 1) {
    const units = ['B', 'KiB', 'MiB', 'GiB', 'TiB', 'PiB', 'EiB'];
    let magnitude = 0;
    let remainder = bytes;
    while (remainder >= 1024) {
        if (magnitude + 1 < units.length) {
            magnitude++;
            remainder /= 1024;
        }
        else {
            break;
        }
    }
    return `${remainder.toFixed(magnitude == 0 ? 0 : precision)} ${units[magnitude]}`;
}
const hexOrBufferToBase64 = (encoded) => {
    if (typeof encoded === 'string') {
        return Buffer.from(encoded.slice(2), 'hex').toString('base64');
    }
    return encoded.toString('base64');
};
exports.hexOrBufferToBase64 = hexOrBufferToBase64;
//# sourceMappingURL=bytes.js.map