"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UnsupportedPostgresError = void 0;
exports.isValidDatabaseBackupName = isValidDatabaseBackupName;
exports.isValidDatabaseRoutineBackupName = isValidDatabaseRoutineBackupName;
exports.isFailedDatabaseBackupName = isFailedDatabaseBackupName;
exports.findDatabaseBackupVersion = findDatabaseBackupVersion;
function isValidDatabaseBackupName(filename) {
    return filename.match(/^[\d\w-.]+\.sql(?:\.gz)?$/);
}
function isValidDatabaseRoutineBackupName(filename) {
    const oldBackupStyle = filename.match(/^immich-db-backup-\d+\.sql\.gz$/);
    const newBackupStyle = filename.match(/^immich-db-backup-\d{8}T\d{6}-v.*-pg.*\.sql\.gz$/);
    return oldBackupStyle || newBackupStyle;
}
function isFailedDatabaseBackupName(filename) {
    return filename.match(/^immich-db-backup-.*\.sql\.gz\.tmp$/);
}
function findDatabaseBackupVersion(filename) {
    return /-v(.*)-/.exec(filename)?.[1];
}
class UnsupportedPostgresError extends Error {
    constructor(databaseVersion) {
        super(`Unsupported PostgreSQL version: ${databaseVersion}`);
    }
}
exports.UnsupportedPostgresError = UnsupportedPostgresError;
//# sourceMappingURL=database-backups.js.map