import { AliasedRawBuilder, Expression, ExpressionBuilder, ExpressionWrapper, Kysely, KyselyConfig, Nullable, Selectable, SelectQueryBuilder, Simplify } from 'kysely';
import postgres from 'postgres';
import { Exif, LockableProperty, Person } from 'src/database';
import { AssetEditActionItem } from 'src/dtos/editing.dto';
import { AssetFileType } from 'src/enum';
import { AssetSearchBuilderOptions } from 'src/repositories/search.repository';
import { DB } from 'src/schema';
import { DatabaseConnectionParams, VectorExtension } from 'src/types';
type Ssl = 'require' | 'allow' | 'prefer' | 'verify-full' | boolean | object;
export declare const asPostgresConnectionConfig: (params: DatabaseConnectionParams) => {
    host: string | undefined;
    port: number | undefined;
    username: string | undefined;
    password: string | undefined;
    database: string | undefined;
    ssl: Ssl | undefined;
};
export declare const getKyselyConfig: (params: DatabaseConnectionParams, options?: Partial<postgres.Options<Record<string, postgres.PostgresType>>>) => KyselyConfig;
export declare const asUuid: (id: string | Expression<string>) => import("kysely").RawBuilder<string>;
export declare const anyUuid: (ids: string[]) => import("kysely").RawBuilder<string>;
export declare const asVector: (embedding: number[]) => import("kysely").RawBuilder<string>;
export declare const unnest: (array: string[]) => import("kysely").RawBuilder<Record<string, string>>;
export declare const removeUndefinedKeys: <T extends object>(update: T, template: unknown) => T;
export declare function toJson<DB, TB extends keyof DB & string, T extends TB | Expression<unknown>>(eb: ExpressionBuilder<DB, TB>, table: T): ExpressionWrapper<DB, TB, Simplify<T extends TB ? Selectable<DB[T]> extends Nullable<infer N> ? N | null : Selectable<DB[T]> : T extends Expression<infer O> ? O extends Nullable<infer N> ? N | null : O : never>>;
export declare const ASSET_CHECKSUM_CONSTRAINT = "UQ_assets_owner_checksum";
export declare const isAssetChecksumConstraint: (error: unknown) => boolean;
export declare function withDefaultVisibility<O>(qb: SelectQueryBuilder<DB, 'asset', O>): SelectQueryBuilder<DB, "asset", O>;
export declare function withExif<O>(qb: SelectQueryBuilder<DB, 'asset', O>): SelectQueryBuilder<{
    library: import("../schema/tables/library.table").LibraryTable;
    api_key: import("../schema/tables/api-key.table").ApiKeyTable;
    workflow: import("../schema/tables/workflow.table").WorkflowTable;
    asset: import("../schema/tables/asset.table").AssetTable;
    album: import("../schema/tables/album.table").AlbumTable;
    person: import("../schema/tables/person.table").PersonTable;
    smart_search: import("../schema/tables/smart-search.table").SmartSearchTable;
    face_search: import("../schema/tables/face-search.table").FaceSearchTable;
    user: import("../schema/tables/user.table").UserTable;
    session: import("../schema/tables/session.table").SessionTable;
    user_metadata_audit: import("../schema/tables/user-metadata-audit.table").UserMetadataAuditTable;
    asset_metadata_audit: import("../schema/tables/asset-metadata-audit.table").AssetMetadataAuditTable;
    asset_face_audit: import("../schema/tables/asset-face-audit.table").AssetFaceAuditTable;
    stack: import("../schema/tables/stack.table").StackTable;
    activity: import("../schema/tables/activity.table").ActivityTable;
    album_audit: import("../schema/tables/album-audit.table").AlbumAuditTable;
    album_asset: import("../schema/tables/album-asset.table").AlbumAssetTable;
    album_asset_audit: import("../schema/tables/album-asset-audit.table").AlbumAssetAuditTable;
    album_user: import("../schema/tables/album-user.table").AlbumUserTable;
    album_user_audit: import("../schema/tables/album-user-audit.table").AlbumUserAuditTable;
    asset_audit: import("../schema/tables/asset-audit.table").AssetAuditTable;
    asset_edit: import("../schema/tables/asset-edit.table").AssetEditTable<import("src/dtos/editing.dto").AssetEditAction>;
    asset_exif: Nullable<import("../schema/tables/asset-exif.table").AssetExifTable>;
    asset_face: import("../schema/tables/asset-face.table").AssetFaceTable;
    asset_file: import("../schema/tables/asset-file.table").AssetFileTable;
    asset_metadata: import("../schema/tables/asset-metadata.table").AssetMetadataTable;
    asset_job_status: import("../schema/tables/asset-job-status.table").AssetJobStatusTable;
    asset_ocr: import("../schema/tables/asset-ocr.table").AssetOcrTable;
    ocr_search: import("../schema/tables/ocr-search.table").OcrSearchTable;
    audit: import("../schema/tables/audit.table").AuditTable;
    geodata_places: import("../schema/tables/geodata-places.table").GeodataPlacesTable;
    memory: import("../schema/tables/memory.table").MemoryTable;
    memory_audit: import("../schema/tables/memory-audit.table").MemoryAuditTable;
    memory_asset: import("../schema/tables/memory-asset.table").MemoryAssetTable;
    memory_asset_audit: import("../schema/tables/memory-asset-audit.table").MemoryAssetAuditTable;
    migrations: import("src/schema").Migrations;
    notification: import("../schema/tables/notification.table").NotificationTable;
    move_history: import("../schema/tables/move.table").MoveTable;
    naturalearth_countries: import("../schema/tables/natural-earth-countries.table").NaturalEarthCountriesTable;
    partner: import("../schema/tables/partner.table").PartnerTable;
    partner_audit: import("../schema/tables/partner-audit.table").PartnerAuditTable;
    person_audit: import("../schema/tables/person-audit.table").PersonAuditTable;
    session_sync_checkpoint: import("../schema/tables/sync-checkpoint.table").SessionSyncCheckpointTable;
    shared_link: import("../schema/tables/shared-link.table").SharedLinkTable;
    shared_link_asset: import("../schema/tables/shared-link-asset.table").SharedLinkAssetTable;
    stack_audit: import("../schema/tables/stack-audit.table").StackAuditTable;
    system_metadata: import("../schema/tables/system-metadata.table").SystemMetadataTable<import("src/enum").SystemMetadataKey>;
    tag: import("../schema/tables/tag.table").TagTable;
    tag_asset: import("../schema/tables/tag-asset.table").TagAssetTable;
    tag_closure: import("../schema/tables/tag-closure.table").TagClosureTable;
    user_audit: import("../schema/tables/user-audit.table").UserAuditTable;
    user_metadata: import("../schema/tables/user-metadata.table").UserMetadataTable<import("src/enum").UserMetadataKey>;
    version_history: import("../schema/tables/version-history.table").VersionHistoryTable;
    plugin: import("../schema/tables/plugin.table").PluginTable;
    plugin_filter: import("../schema/tables/plugin.table").PluginFilterTable;
    plugin_action: import("../schema/tables/plugin.table").PluginActionTable;
    workflow_filter: import("../schema/tables/workflow.table").WorkflowFilterTable;
    workflow_action: import("../schema/tables/workflow.table").WorkflowActionTable;
}, "asset" | "asset_exif", O & {
    exifInfo: Exif | null;
}>;
export declare function withExifInner<O>(qb: SelectQueryBuilder<DB, 'asset', O>): SelectQueryBuilder<DB, "asset" | "asset_exif", O & {
    exifInfo: Exif;
}>;
export declare function withSmartSearch<O>(qb: SelectQueryBuilder<DB, 'asset', O>): SelectQueryBuilder<{
    library: import("../schema/tables/library.table").LibraryTable;
    api_key: import("../schema/tables/api-key.table").ApiKeyTable;
    workflow: import("../schema/tables/workflow.table").WorkflowTable;
    asset: import("../schema/tables/asset.table").AssetTable;
    album: import("../schema/tables/album.table").AlbumTable;
    person: import("../schema/tables/person.table").PersonTable;
    smart_search: Nullable<import("../schema/tables/smart-search.table").SmartSearchTable>;
    face_search: import("../schema/tables/face-search.table").FaceSearchTable;
    user: import("../schema/tables/user.table").UserTable;
    session: import("../schema/tables/session.table").SessionTable;
    user_metadata_audit: import("../schema/tables/user-metadata-audit.table").UserMetadataAuditTable;
    asset_metadata_audit: import("../schema/tables/asset-metadata-audit.table").AssetMetadataAuditTable;
    asset_face_audit: import("../schema/tables/asset-face-audit.table").AssetFaceAuditTable;
    stack: import("../schema/tables/stack.table").StackTable;
    activity: import("../schema/tables/activity.table").ActivityTable;
    album_audit: import("../schema/tables/album-audit.table").AlbumAuditTable;
    album_asset: import("../schema/tables/album-asset.table").AlbumAssetTable;
    album_asset_audit: import("../schema/tables/album-asset-audit.table").AlbumAssetAuditTable;
    album_user: import("../schema/tables/album-user.table").AlbumUserTable;
    album_user_audit: import("../schema/tables/album-user-audit.table").AlbumUserAuditTable;
    asset_audit: import("../schema/tables/asset-audit.table").AssetAuditTable;
    asset_edit: import("../schema/tables/asset-edit.table").AssetEditTable<import("src/dtos/editing.dto").AssetEditAction>;
    asset_exif: import("../schema/tables/asset-exif.table").AssetExifTable;
    asset_face: import("../schema/tables/asset-face.table").AssetFaceTable;
    asset_file: import("../schema/tables/asset-file.table").AssetFileTable;
    asset_metadata: import("../schema/tables/asset-metadata.table").AssetMetadataTable;
    asset_job_status: import("../schema/tables/asset-job-status.table").AssetJobStatusTable;
    asset_ocr: import("../schema/tables/asset-ocr.table").AssetOcrTable;
    ocr_search: import("../schema/tables/ocr-search.table").OcrSearchTable;
    audit: import("../schema/tables/audit.table").AuditTable;
    geodata_places: import("../schema/tables/geodata-places.table").GeodataPlacesTable;
    memory: import("../schema/tables/memory.table").MemoryTable;
    memory_audit: import("../schema/tables/memory-audit.table").MemoryAuditTable;
    memory_asset: import("../schema/tables/memory-asset.table").MemoryAssetTable;
    memory_asset_audit: import("../schema/tables/memory-asset-audit.table").MemoryAssetAuditTable;
    migrations: import("src/schema").Migrations;
    notification: import("../schema/tables/notification.table").NotificationTable;
    move_history: import("../schema/tables/move.table").MoveTable;
    naturalearth_countries: import("../schema/tables/natural-earth-countries.table").NaturalEarthCountriesTable;
    partner: import("../schema/tables/partner.table").PartnerTable;
    partner_audit: import("../schema/tables/partner-audit.table").PartnerAuditTable;
    person_audit: import("../schema/tables/person-audit.table").PersonAuditTable;
    session_sync_checkpoint: import("../schema/tables/sync-checkpoint.table").SessionSyncCheckpointTable;
    shared_link: import("../schema/tables/shared-link.table").SharedLinkTable;
    shared_link_asset: import("../schema/tables/shared-link-asset.table").SharedLinkAssetTable;
    stack_audit: import("../schema/tables/stack-audit.table").StackAuditTable;
    system_metadata: import("../schema/tables/system-metadata.table").SystemMetadataTable<import("src/enum").SystemMetadataKey>;
    tag: import("../schema/tables/tag.table").TagTable;
    tag_asset: import("../schema/tables/tag-asset.table").TagAssetTable;
    tag_closure: import("../schema/tables/tag-closure.table").TagClosureTable;
    user_audit: import("../schema/tables/user-audit.table").UserAuditTable;
    user_metadata: import("../schema/tables/user-metadata.table").UserMetadataTable<import("src/enum").UserMetadataKey>;
    version_history: import("../schema/tables/version-history.table").VersionHistoryTable;
    plugin: import("../schema/tables/plugin.table").PluginTable;
    plugin_filter: import("../schema/tables/plugin.table").PluginFilterTable;
    plugin_action: import("../schema/tables/plugin.table").PluginActionTable;
    workflow_filter: import("../schema/tables/workflow.table").WorkflowFilterTable;
    workflow_action: import("../schema/tables/workflow.table").WorkflowActionTable;
}, "asset" | "smart_search", O & {
    smartSearch: {
        assetId: string;
        embedding: string;
    } | null;
}>;
export declare function withFaces(eb: ExpressionBuilder<DB, 'asset'>, withHidden?: boolean, withDeletedFace?: boolean): AliasedRawBuilder<{
    id: string;
    assetId: string;
    updatedAt: Date;
    deletedAt: Date | null;
    updateId: string;
    personId: string | null;
    imageWidth: number;
    imageHeight: number;
    boundingBoxX1: number;
    boundingBoxY1: number;
    boundingBoxX2: number;
    boundingBoxY2: number;
    sourceType: import("src/enum").SourceType;
    isVisible: boolean;
}[], "faces">;
export declare function withFiles(eb: ExpressionBuilder<DB, 'asset'>, type?: AssetFileType): AliasedRawBuilder<{
    id: string;
    type: AssetFileType;
    path: string;
    isEdited: boolean;
}[], "files">;
export declare function withFilePath(eb: ExpressionBuilder<DB, 'asset'>, type: AssetFileType): SelectQueryBuilder<DB, "asset" | "asset_file", {
    path: string;
}>;
export declare function withFacesAndPeople(eb: ExpressionBuilder<DB, 'asset'>, withHidden?: boolean, withDeletedFace?: boolean): AliasedRawBuilder<{
    id: string;
    assetId: string;
    updatedAt: Date;
    deletedAt: Date | null;
    updateId: string;
    personId: string | null;
    imageWidth: number;
    imageHeight: number;
    boundingBoxX1: number;
    boundingBoxY1: number;
    boundingBoxX2: number;
    boundingBoxY2: number;
    sourceType: import("src/enum").SourceType;
    isVisible: boolean;
    person: Person;
}[], "faces">;
export declare function hasPeople<O>(qb: SelectQueryBuilder<DB, 'asset', O>, personIds: string[]): SelectQueryBuilder<DB & {
    has_people: {
        assetId: string;
    };
}, "asset" | "has_people", O>;
export declare function inAlbums<O>(qb: SelectQueryBuilder<DB, 'asset', O>, albumIds: string[]): SelectQueryBuilder<DB & {
    has_album: {
        assetId: string;
    };
}, "asset" | "has_album", O>;
export declare function hasTags<O>(qb: SelectQueryBuilder<DB, 'asset', O>, tagIds: string[]): SelectQueryBuilder<DB & {
    has_tags: {
        assetId: string;
    };
}, "asset" | "has_tags", O>;
export declare function withOwner(eb: ExpressionBuilder<DB, 'asset'>): AliasedRawBuilder<{
    name: string;
    id: string;
    email: string;
    profileImagePath: string;
    avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB, "asset" | "user", "avatarColor">;
    profileChangedAt: Date;
} | null, "owner">;
export declare function withLibrary(eb: ExpressionBuilder<DB, 'asset'>): AliasedRawBuilder<{
    name: string;
    id: string;
    updatedAt: Date;
    createdAt: Date;
    deletedAt: Date | null;
    updateId: string;
    ownerId: string;
    importPaths: string[];
    exclusionPatterns: string[];
    refreshedAt: Date | null;
} | null, "library">;
export declare function withTags(eb: ExpressionBuilder<DB, 'asset'>): AliasedRawBuilder<{
    id: string;
    value: string;
    createdAt: Date;
    updatedAt: Date;
    color: string | null;
    parentId: string | null;
}[], "tags">;
export declare function truncatedDate<O>(): import("kysely").RawBuilder<O>;
export declare function withTagId<O>(qb: SelectQueryBuilder<DB, 'asset', O>, tagId: string): SelectQueryBuilder<DB, "asset", O>;
export declare const tokenizeForSearch: (text: string) => string[];
type AliasedEditActions = AliasedRawBuilder<AssetEditActionItem[], 'edits'>;
export declare function withEdits(eb: ExpressionBuilder<DB, 'asset'>): AliasedEditActions;
export declare function searchAssetBuilder(kysely: Kysely<DB>, options: AssetSearchBuilderOptions): SelectQueryBuilder<DB, "asset", Partial<Omit<unknown, never>> & Partial<Omit<{
    exifInfo: Exif;
}, never>> & Partial<Omit<{
    faces: {
        id: string;
        assetId: string;
        updatedAt: Date;
        deletedAt: Date | null;
        updateId: string;
        personId: string | null;
        imageWidth: number;
        imageHeight: number;
        boundingBoxX1: number;
        boundingBoxY1: number;
        boundingBoxX2: number;
        boundingBoxY2: number;
        sourceType: import("src/enum").SourceType;
        isVisible: boolean;
        person: Person;
    }[];
}, "exifInfo">> & Partial<Omit<unknown, "exifInfo" | "faces">>>;
export type ReindexVectorIndexOptions = {
    indexName: string;
    lists?: number;
};
type VectorIndexQueryOptions = {
    table: string;
    vectorExtension: VectorExtension;
} & ReindexVectorIndexOptions;
export declare function vectorIndexQuery({ vectorExtension, table, indexName, lists }: VectorIndexQueryOptions): string;
export declare const updateLockedColumns: <T extends Record<string, unknown> & {
    lockedProperties?: LockableProperty[];
}>(exif: T) => T;
export {};
